package com.ellabook.entity.operation;

import com.ellabook.util.parameterChecking.CheckValue;
import com.ellabook.util.parameterChecking.NotEmpty;

import java.util.Date;

public class AgentInfo {
    private Integer id;

    private String uid;

    private String agentCode;

    @NotEmpty
    @CheckValue("^.{1,32}$")
    private String agentName;

    @NotEmpty
    @CheckValue()
    private String country;

    private String province;

    private String city;

    private String addressDesc;

    private String email;

    private Integer schoolChannelDivideRate;

    private Integer otherChannelDivideRate;

    private Integer schoolNum;

    private Integer mediaNum;

    private String discountRate;

    @NotEmpty
    private Date cooperateStartTime;

    @NotEmpty
    private Date cooperateEndTime;

    private Date createTime;

    private Date updateTime;

    @NotEmpty
    @CheckValue()
    private String status;

    @CheckValue("^.{0,64}$")
    private String remark;

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getUid() {
        return uid;
    }

    public void setUid(String uid) {
        this.uid = uid == null ? null : uid.trim();
    }

    public String getAgentCode() {
        return agentCode;
    }

    public void setAgentCode(String agentCode) {
        this.agentCode = agentCode == null ? null : agentCode.trim();
    }

    public String getAgentName() {
        return agentName;
    }

    public void setAgentName(String agentName) {
        this.agentName = agentName == null ? null : agentName.trim();
    }

    public String getCountry() {
        return country;
    }

    public void setCountry(String country) {
        this.country = country == null ? null : country.trim();
    }

    public String getProvince() {
        return province;
    }

    public void setProvince(String province) {
        this.province = province == null ? null : province.trim();
    }

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city == null ? null : city.trim();
    }

    public String getAddressDesc() {
        return addressDesc;
    }

    public void setAddressDesc(String addressDesc) {
        this.addressDesc = addressDesc == null ? null : addressDesc.trim();
    }

    public Integer getSchoolChannelDivideRate() {
        return schoolChannelDivideRate;
    }

    public void setSchoolChannelDivideRate(Integer schoolChannelDivideRate) {
        this.schoolChannelDivideRate = schoolChannelDivideRate;
    }

    public Integer getOtherChannelDivideRate() {
        return otherChannelDivideRate;
    }

    public void setOtherChannelDivideRate(Integer otherChannelDivideRate) {
        this.otherChannelDivideRate = otherChannelDivideRate;
    }

    public String getDiscountRate() {
        return discountRate;
    }

    public void setDiscountRate(String discountRate) {
        this.discountRate = discountRate;
    }

    public Date getCooperateStartTime() {
        return cooperateStartTime;
    }

    public void setCooperateStartTime(Date cooperateStartTime) {
        this.cooperateStartTime = cooperateStartTime;
    }

    public Date getCooperateEndTime() {
        return cooperateEndTime;
    }

    public void setCooperateEndTime(Date cooperateEndTime) {
        this.cooperateEndTime = cooperateEndTime;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status == null ? null : status.trim();
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark == null ? null : remark.trim();
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Integer getSchoolNum() {
        return schoolNum;
    }

    public void setSchoolNum(Integer schoolNum) {
        this.schoolNum = schoolNum;
    }

    public Integer getMediaNum() {
        return mediaNum;
    }

    public void setMediaNum(Integer mediaNum) {
        this.mediaNum = mediaNum;
    }
}