package com.ellabook.entity.listenBook.DTO;

import lombok.Data;

import java.util.List;

/**
 * 听单信息（APP专用）
 */
@Data
public class LbListenAppDto {
    /**
     * 听单详情
     */
    private List<LbListenDetailOfAppDto> listenDetails;

    private Long id;

    /**
     * 听单code
     */
    private String listenCode;
    /**
     * 听单名称
     */
    private String listenName;
    /**
     * 听单类型 voice-音频列表
     */
    private String listenType;
    /**
     * 音频数
     */
    private Integer voiceNum;
    /**
     * 音频总时长
     */
    private String voiceTotalTime;
    /**
     * 栏目排版样式（HORIZONTAL_NO_SUBTITLE:横排无音频副标题,PORTRAIT_WITH_SUBTITLE:竖排有音标副标题）
     */
    private String columnStyle;
    /**
     * 列表样式(HORIZONTAL_NO_SUBTITLE:横排无音频副标题,PORTRAIT_WITH_SUBTITLE:竖排有音标副标题)
     */
    private String listType;
    /**
     * 跳转类型(JUMP_CURRENT：跳转当前)
     */
    private String jumpType;
    /**
     * 跳转列表链接文字
     */
    private String jumpDesc;
    /**
     * 首页音频展示数量
     */
    private Integer homeShowNum;

    private String targetPage;
}
