package com.ellabook.entity.library;

import java.util.Map;
import java.util.UUID;

import static com.ellabook.util.WXPayConstant.APPID;
import static com.ellabook.util.WXPayConstant.KEY;
import static com.ellabook.util.WXPayConstant.MCH_ID;

public class WechatNativeParam extends WeChatUnifieDorderParam {
    private String product_id;

    public WechatNativeParam() {
        super.setAppid(APPID);
        super.setMch_id(MCH_ID);
        super.setKey(KEY);
        super.setTrade_type("NATIVE");
        super.setNonce_str(UUID.randomUUID().toString().replace("-", ""));
    }

    @Override
    public void toMap() {
        Map<String, String> map = super.getMap();
        map.put("appid", super.getAppid());
        map.put("attach", super.getAttach());
        map.put("body", super.getBody());
        map.put("mch_id", super.getMch_id());
        map.put("nonce_str", super.getNonce_str());
        map.put("notify_url", super.getNotify_url());
        map.put("out_trade_no", super.getOut_trade_no());
        map.put("spbill_create_ip", super.getSpbill_create_ip());
        map.put("total_fee", super.getTotal_fee());
        map.put("trade_type", super.getTrade_type());
        map.put("product_id", product_id);
    }

    public String getProduct_id() {
        return product_id;
    }

    public void setProduct_id(String product_id) {
        this.product_id = product_id;
    }
}
