package com.ellabook.entity.home;


import com.ellabook.entity.home.vo.CustomColumnBookListVo;

import java.util.Date;
import java.util.List;

/**
 * @author junboxiang
 * @Description: 自定义栏目 实体
 * @date 2018/9/14
 */
public class CustomColumn {

    /**
     * 主键id
     */
    private Long id;

    /**
     * 自定义栏目code
     */
    private String columnCode;

    /**
     * 栏目标题
     */
    private String columnTitle;

    /**
     * 栏目类型  栏目风格 SLIDE_HORIZONTAL:横向滑动,SLIDE_PORTRAIT:纵向滑动,IMAGE_TEXT:图文
     */
    private String columnStyle;

    /**
     * 栏目最大数量
     */
    private Integer columnSourceNum;


    /**
     * 跳转的目标类型 BOOK_DETAIL:图书详情 ,H5:H5页面,SYSTEM_INTERFACE:系统界面 ,BOOK_LIST:图书列表页 ,COURSE_LIST:课程列表页
     * 目前只用到  BOOK_DETAIL
     */
    private String targetType;

    /**
     * 跳转描述
     */
    private String targetDesc;

    /**
     * 查看全部 跳转URL
     */
    private String targetPage;

    /**
     * 排序
     */
    private Integer idx;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 状态  NORMAL:未展示，ON_LINE : 展示 PUBLISH:发布  EXCEPTION：删除
     */
    private String status;

    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 跳转类型 JUMP_CURRENT：跳转当前、JUMP_OTHER：跳转其他
     */
    private String jumpType;

    /**
     * 列表样式（BRIEF:简要   COVER：封面）
     */
    private String listType;

    /**
     * 关联图书集合  --- 查询用
     */
    private List<CustomColumnBookListVo> customColumnBookListList;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getColumnCode() {
        return columnCode;
    }

    public void setColumnCode(String columnCode) {
        this.columnCode = columnCode == null ? null : columnCode.trim();
    }

    public String getColumnTitle() {
        return columnTitle;
    }

    public void setColumnTitle(String columnTitle) {
        this.columnTitle = columnTitle == null ? null : columnTitle.trim();
    }

    public String getColumnStyle() {
        return columnStyle;
    }

    public void setColumnStyle(String columnStyle) {
        this.columnStyle = columnStyle == null ? null : columnStyle.trim();
    }

    public Integer getColumnSourceNum() {
        return columnSourceNum;
    }

    public void setColumnSourceNum(Integer columnSourceNum) {
        this.columnSourceNum = columnSourceNum;
    }

    public String getTargetType() {
        return targetType;
    }

    public void setTargetType(String targetType) {
        this.targetType = targetType == null ? null : targetType.trim();
    }

    public String getTargetDesc() {
        return targetDesc;
    }

    public void setTargetDesc(String targetDesc) {
        this.targetDesc = targetDesc == null ? null : targetDesc.trim();
    }

    public String getTargetPage() {
        return targetPage;
    }

    public void setTargetPage(String targetPage) {
        this.targetPage = targetPage == null ? null : targetPage.trim();
    }

    public Integer getIdx() {
        return idx;
    }

    public void setIdx(Integer idx) {
        this.idx = idx;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status == null ? null : status.trim();
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public String getJumpType() {
        return jumpType;
    }

    public void setJumpType(String jumpType) {
        this.jumpType = jumpType == null ? null : jumpType.trim();
    }

    public String getListType() {
        return listType;
    }

    public void setListType(String listType) {
        this.listType = listType == null ? null : listType.trim();
    }

    public List<CustomColumnBookListVo> getCustomColumnBookListList() {
        return customColumnBookListList;
    }

    public void setCustomColumnBookListList(List<CustomColumnBookListVo> customColumnBookListList) {
        this.customColumnBookListList = customColumnBookListList;
    }
}