package com.ellabook.entity.home;

import org.apache.commons.lang3.StringUtils;

import java.util.Date;

public class CourseBookTask {
    private Integer id;

    private String bookCode;

    private String taskType;

    private String taskContent;

    private String status;

    private Date createTime;

    private Date updateTime;

    public CourseBookTask(String taskType, String bookName) {
        if (StringUtils.equalsIgnoreCase(taskType, "photo") && StringUtils.isBlank(this.taskContent)) {
            this.taskContent = "和宝宝一起读完《" + bookName + "》这本书，并完成书后的大头贴任务，就可以提交作业了";
        }
        if (StringUtils.equalsIgnoreCase(taskType, "voice") && StringUtils.isBlank(this.taskContent)) {
            this.taskContent = "和宝宝一起读完《" + bookName + "》，请宝宝讲一讲，TA最喜欢的人物或者情节";
        }
        this.taskType = taskType;
    }

    public CourseBookTask() {
    }

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getBookCode() {
        return bookCode;
    }

    public void setBookCode(String bookCode) {
        this.bookCode = bookCode == null ? null : bookCode.trim();
    }

    public String getTaskType() {
        return taskType;
    }

    public void setTaskType(String taskType) {
        this.taskType = taskType == null ? null : taskType.trim();
    }

    public String getTaskContent() {
        return taskContent;
    }

    public void setTaskContent(String taskContent) {
        this.taskContent = taskContent == null ? null : taskContent.trim();
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status == null ? null : status.trim();
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }
}
