package com.ellabook.entity.enums;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public enum BookStudySourceType {
    BOOK_BORROWED("BOOK_BORROWED", OwnStatus.TEMPORARY, "借阅"),

    BOOK_RENT("BOOK_RENT", OwnStatus.TEMPORARY, "租书"),

    BOOK_COUPON("BOOK_COUPON", OwnStatus.FOREVER, "红包购买"),

    BOOK_COUPON_BALANCE("BOOK_COUPON_BALANCE", OwnStatus.FOREVER, "红包+余额购买"),

    BOOK_FREE("BOOK_FREE", OwnStatus.FOREVER, "免费购买"),

    BOOK_MONEY("BOOK_MONEY", OwnStatus.FOREVER, "余额购买"),

    BOOK_SEND("BOOK_SEND", OwnStatus.FOREVER, "送书"),

    BOOK_TASK("BOOK_TASK", OwnStatus.FOREVER, "任务获得"),

    BOOK_POINTS("BOOK_POINTS", OwnStatus.FOREVER, "积分购买"),

    ACHIEVEMENT_LEVEL("ACHIEVEMENT_LEVEL", OwnStatus.FOREVER, "用户阅读等级获得");

    private String value;
    private OwnStatus ownStatus;
    private String desc;

    BookStudySourceType() {
    }

    BookStudySourceType(String value, OwnStatus ownStatus, String desc) {
        this.value = value;
        this.ownStatus = ownStatus;
        this.desc = desc;
    }

    /**
     * 永久有效类型 列表
     */
    public static List<String> foreverSourceTypeList() {
        List<String> list = Arrays.asList(values()).stream()
                .filter(e -> Objects.equals(OwnStatus.FOREVER.getValue(), e.getOwnStatus().getValue()))
                .map(e -> e.getValue())
                .collect(Collectors.toList());
        return list;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public OwnStatus getOwnStatus() {
        return ownStatus;
    }

    public void setOwnStatus(OwnStatus ownStatus) {
        this.ownStatus = ownStatus;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
