package com.ellabook.entity.book.vo;

import com.ellabook.entity.book.Book;
import com.ellabook.entity.book.BookSubject;
import com.ellabook.entity.book.BookSubjectComment;
import com.ellabook.entity.book.BookSubjectIntroduction;
import com.ellabook.entity.order.Goods;
import com.ellabook.entity.order.dto.JurisdictionDetailDTO;
import com.ellabook.entity.user.AppUser;
import com.ellabook.util.BigDecimalUtil;
import lombok.*;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

import java.math.BigDecimal;
import java.util.*;

/*
用户已拥有=图书书房已拥有+专题书房已拥有
打包价=（专题图书-用户已拥有）的图书商品的现价之和
优惠活动=打包价*专题商品的商品折扣
用户已拥有>0,提示“已帮您筛选掉已有图书”
 */
@EqualsAndHashCode(callSuper = true)
//@Builder
//@Data
@Setter
//    @Getter
@NoArgsConstructor
@AllArgsConstructor
public class BookSubjectVO extends BookSubject {
    @Getter
    /**
     * 专题简介 列表
     */
    private List<BookSubjectIntroduction> introductionList = new ArrayList<>();

    @Getter
    /**
     * tag 列表
     */
    private List<String> tagList = new ArrayList<>();
    @Getter
    /**
     * book 列表
     */
    private List<Book> bookList = new ArrayList<>();
    @Getter
    /**
     * 评论 列表
     */
    private List<BookSubjectComment> commentList = new ArrayList<>();
    @Getter
    private int commentSize;
    @Getter
    /**
     * 购买须知
     */
    private String purchaseNotes;

    /********************************************************/
    @Getter
    /**
     * 是否会员租用
     */
    private String isVip = "VIP_NO";

    @Getter
    /**
     * 是否高级会员租用
     */
    private String isSvip = "VIP_NO";

    @Getter
    private String goodsCode;
    private String goodsName;
    private String goodsType;
    //    @Getter
//    private String thirdCode;
    private double goodsDiscount;
    //20190404 直接使用图书包goods_price，goods_src_price//图书包价格
    @Getter
    /**
     * 专题图书商品现价之和
     */
    private double bookTotalPrice = 0.00D;
    @Getter
    /**
     * 专题图书商品现价之和 * 折扣
     */
    private double bookTotalDiscountPrice = 0.00D;
    @Getter
    /**
     * 打包价
     */
    private double balePrice = 0.00D;
    @Getter
    /**
     * 原价
     */
    private double originalPrice = 0.00D;
    @Getter
    /**
     * 优惠金额
     */
    private double discountAmount = 0.00D;
    @Getter
    /**
     * packageGoodsPrice
     */
    private double packageGoodsPrice = 0.00D;

    @Getter
    /**
     * 用户拥有该专题的状态:NONE未拥有,BOOK_MONEY : 花钱购书 ,BOOK_COUPON : 红包购书,BOOK_FREE : 免费购书,BOOK_COUPON_BALANCE : 红包+余额购书, BOOK_SEND : 送书 ,BOOK_RENT : 租书 ,BOOK_BORROWED : 借阅
     */
    private String haveState = "NONE";
    @Getter
    /**
     * 是否需结算
     */
    private String toSettle = "true";
    @Getter
    /**
     * 结算:过滤已经拥有书房/专题内包含的图书
     */
    private String filteredBook = "false";


    @Getter
    private Integer subjectBookNum;

    @Getter
    private List<JurisdictionDetailDTO> jurisdictionDetail;//
    @Getter
    private String userBorrow = "NO";//
    @Getter
    private String bookSubjectBorrow = "NO";//
    @Getter
    private Long limitReadDays = 0l;

    @Getter
    private int shelvesOffNum;

    @Getter
    /**
     * 会员
     */
    private AppUser appUser;//

    @Getter
    private String shelvesFlag;

    public void updateForVO() {
        String[] tags = StringUtils.split(getTags(), ",");
        if (tags != null) {
            setTagList(Arrays.asList(tags));
        }
    }


    public void updatePrices(Map<String, List<Goods>> bookPriceMap, Set<String> leftBookCodeSet) {
        double goodsDiscount = bookTotalPrice <= 0D ? 0D : BigDecimalUtil.div(bookTotalDiscountPrice, bookTotalPrice);//20190411非图书包折扣，计算折扣
        double originalPrice = bookTotalPrice;
        double bookTotalPrice = 0D;
        //double balePrice = bookTotalDiscountPrice;
        double balePrice = 0D;
        double havePrice = 0D;
        //非永久拥有的book
        for (Map.Entry<String, List<Goods>> kv : bookPriceMap.entrySet()) {
            List<Goods> goodsList = kv.getValue();
            if (CollectionUtils.isEmpty(goodsList)) {
                continue;
            }
            Goods goods = goodsList.get(0);
            if (goods != null) {
                BigDecimal goodsPrice = goods.getGoodsPrice();
                if (goodsPrice != null) {
                    bookTotalPrice = BigDecimalUtil.add(bookTotalPrice, goodsPrice.doubleValue());

                    String bookCode = kv.getKey();
                    if (leftBookCodeSet.contains(bookCode)) {
//                        originalPrice = BigDecimalUtil.add(originalPrice, goodsPrice.doubleValue());
                    } else {
                        originalPrice = originalPrice - goodsPrice.doubleValue();
                        //balePrice = balePrice - goodsPrice.doubleValue() * goodsDiscount;
                        havePrice = BigDecimalUtil.add(havePrice, goodsPrice.doubleValue());//已拥有价格之和
                    }
                }
            }
        }
        balePrice = BigDecimalUtil.mul(BigDecimalUtil.div(BigDecimalUtil.sub(bookTotalPrice, havePrice), bookTotalPrice), bookTotalDiscountPrice);
//        setBookTotalPrice(BigDecimalUtil.round(bookTotalPrice, 2));
//        setBookTotalDiscountPrice(BigDecimalUtil.mul(new BigDecimal(getBookTotalPrice()), new BigDecimal(goodsDiscount * 0.1D), 2).doubleValue());
        if (originalPrice > 0D) {
            setOriginalPrice(BigDecimalUtil.round(originalPrice, 2));
//            setBalePrice(BigDecimalUtil.mul(new BigDecimal(getOriginalPrice()), new BigDecimal(goodsDiscount * 0.1D), 2).doubleValue());
            if (balePrice > 0D) {
                setBalePrice(BigDecimalUtil.round(balePrice, 2));
            }
            setDiscountAmount(BigDecimalUtil.sub(new BigDecimal(getOriginalPrice()), new BigDecimal(getBalePrice()), 2).doubleValue());
        }

        if (getBalePrice() <= 0D) {
            setToSettle("false");
        }
    }

    @Deprecated
    public double takeGoodsDiscount() {
        return 0D;
    }

    public Goods generateGoods() {
        Goods goods = new Goods();
        goods.setGoodsCode(goodsCode);
        goods.setGoodsName(goodsName);
        goods.setGoodsType(goodsType);
        goods.setThirdCode(getPackageCode());
        return goods;
    }

    public String getThirdCode() {
        return getPackageCode();
    }
}