package com.ellabook.entity.book.dto;

import com.ellabook.entity.PublicParam;
import com.ellabook.entity.ResponseParams;
import com.ellabook.entity.book.PointsExchange;
import com.constants.BookCodeConstantUtil;
import com.ellabook.util.ConstantUtil;
import com.ellabook.util.ResponseParamsUtil;
import lombok.*;
import org.apache.commons.lang.StringUtils;

import java.util.Date;
import java.util.Optional;

@EqualsAndHashCode(callSuper = true)
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
public class PointsExchangeDTO extends PointsExchange {
    private PublicParam publicParam;
    private int points;
    private String uid;
    private String channelCode;

    private Date startTime;
    private Date endTime;

    private Date currentCycleStartTime;
    private Date currentCycleEndTime;

    private int userTotalCount;
    private int userCycleCount;

    public String getUid() {
        return StringUtils.isNotBlank(uid) ? uid : publicParam == null ? null : publicParam.getUid();
    }

    public String getChannelCode() {
        return StringUtils.isNotBlank(channelCode) ? channelCode : publicParam == null ? null : publicParam.getChannelCode();
    }

    /**
     * 计算周期时间
     *
     * @param now
     * @param pointsExchangeDTO
     * @return
     * @throws Exception
     */
    public void computeCycleTime(Date now, PointsExchangeDTO pointsExchangeDTO) throws Exception {
        if (startTime == null || endTime == null) {
            throw new Exception("time err");
        }
        long startTimeVal = getStartTime().getTime();
        Date endTime = getEndTime();

        long period = now.getTime() - startTimeVal;
        long realCycleTime = getCycleTime() * 24 * 3600 * 1000L;    // 配置中记录的是秒，转换为毫秒循环时间
        long overTimes = Math.floorDiv(period, realCycleTime);
        Date currentCycleStartTime = new Date(startTimeVal + overTimes * realCycleTime);
        Date currentCycleEndTime = new Date(currentCycleStartTime.getTime() + realCycleTime);
        currentCycleEndTime = currentCycleEndTime.before(endTime) ? currentCycleEndTime : endTime;

        pointsExchangeDTO.setCurrentCycleStartTime(currentCycleStartTime);
        pointsExchangeDTO.setCurrentCycleEndTime(currentCycleEndTime);
    }

    /**
     * 校验用户与该兑换配置
     *
     * @param pointsExchange
     * @return
     */
    public ResponseParams checkUserPointsExchange(PointsExchangeDTO pointsExchange, ResponseParamsUtil responseParamsUtil) {
        int maxTimes = Optional.ofNullable(pointsExchange.getMaxTimes()).orElse(-1);
        int exchangeTimes = Optional.ofNullable(pointsExchange.getExchangeTimes()).orElse(0);
        if (!(userCycleCount < exchangeTimes)) {
            return responseParamsUtil.fail("10020004", pointsExchange.getCycleTime() + "天内只能兑换" + pointsExchange.getExchangeTimes() + "次哦", "积分兑换");
        }
        if (!(maxTimes == -1 ? true : userTotalCount < maxTimes)) {
            return responseParamsUtil.fail(BookCodeConstantUtil.POINTS_EXCHANGE_USER_FAIL, BookCodeConstantUtil.POINTS_EXCHANGE_USER_FAIL_DESC, "积分兑换");
        }
        /*return (maxTimes == -1 ? true : userTotalCount < maxTimes) && userCycleCount < exchangeTimes;*/
        return responseParamsUtil.success(ConstantUtil.SUCCESS_DESCRIBE, "积分兑换", null);
    }
}