package com.ellabook.entity.book.dto;

import com.ellabook.entity.book.vo.GoodsPointPriceVO;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Objects;

/**
 * @author mengxiangchao@ellabook.cn
 * @date 2018/3/13
 */
public class BookPackageByCodeDto {
    private String packageCode;
    private String packageName;
    private String packageIntroduction;
    private String coverUrl;
    private String goodsPrice;
    private String goodsMarketprice;
    private String iosPriceId;
    private String iosPrice;
    private String goodsSrcPrice;
    private String status;
    private String hasBuyNum;
    private String shelvesOffNum;
    private String isBuy;
    private String isAllBuy;
    private String goodsState;
    private Integer average;

    /**
     * 图书包书籍评价评分
     */
    private BigDecimal avgScore;

    /**
     * 包含图书数量
     */
    private BigDecimal sumNum;
    /**
     * 平均价格
     */
    private String avgPrice;
    /**
     * IOS评价价格
     */
    private String avgIosPrice;

    private GoodsPointPriceVO pointPrice;

    public String getIosPriceId() {
        return iosPriceId;
    }

    public void setIosPriceId(String iosPriceId) {
        this.iosPriceId = iosPriceId;
    }

    public String getIosPrice() {
        return iosPrice;
    }

    public void setIosPrice(String iosPrice) {
        this.iosPrice = iosPrice;
    }

    public String getPackageCode() {
        return packageCode;
    }

    public void setPackageCode(String packageCode) {
        this.packageCode = packageCode;
    }

    public String getPackageName() {
        return packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getPackageIntroduction() {
        return packageIntroduction;
    }

    public void setPackageIntroduction(String packageIntroduction) {
        this.packageIntroduction = packageIntroduction;
    }

    public String getCoverUrl() {
        return coverUrl;
    }

    public void setCoverUrl(String coverUrl) {
        this.coverUrl = coverUrl;
    }

    public String getGoodsPrice() {
        return goodsPrice;
    }

    public void setGoodsPrice(String goodsPrice) {
        this.goodsPrice = goodsPrice;
    }

    public String getGoodsMarketprice() {
        return goodsMarketprice;
    }

    public void setGoodsMarketprice(String goodsMarketprice) {
        this.goodsMarketprice = goodsMarketprice;
    }

    public String getGoodsSrcPrice() {
        return goodsSrcPrice;
    }

    public void setGoodsSrcPrice(String goodsSrcPrice) {
        this.goodsSrcPrice = goodsSrcPrice;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getHasBuyNum() {
        return hasBuyNum;
    }

    public void setHasBuyNum(String hasBuyNum) {
        this.hasBuyNum = hasBuyNum;
    }

    public String getShelvesOffNum() {
        return shelvesOffNum;
    }

    public void setShelvesOffNum(String shelvesOffNum) {
        this.shelvesOffNum = shelvesOffNum;
    }

    public String getIsBuy() {
        return isBuy;
    }

    public void setIsBuy(String isBuy) {
        this.isBuy = isBuy;
    }

    public String getIsAllBuy() {
        return isAllBuy;
    }

    public void setIsAllBuy(String isAllBuy) {
        this.isAllBuy = isAllBuy;
    }

    public String getGoodsState() {
        return goodsState;
    }

    public void setGoodsState(String goodsState) {
        this.goodsState = goodsState;
    }

    public BigDecimal getAvgScore() {
        return avgScore;
    }

    public void setAvgScore(BigDecimal avgScore) {
        if (Objects.nonNull(avgScore)) {
            avgScore.setScale(2, RoundingMode.HALF_UP);
        }
        this.avgScore = avgScore;
    }

    public Integer getAverage() {
        return average;
    }

    public void setAverage(Integer average) {
        this.average = average;
    }

    public BigDecimal getSumNum() {
        return sumNum;
    }

    public void setSumNum(BigDecimal sumNum) {
        this.sumNum = sumNum;
    }

    public String getAvgPrice() {
        return avgPrice;
    }

    public void setAvgPrice(String avgPrice) {
        this.avgPrice = avgPrice;
    }

    public String getAvgIosPrice() {
        return avgIosPrice;
    }

    public void setAvgIosPrice(String avgIosPrice) {
        this.avgIosPrice = avgIosPrice;
    }


    public GoodsPointPriceVO getPointPrice() {
        return pointPrice;
    }

    public void setPointPrice(GoodsPointPriceVO pointPrice) {
        this.pointPrice = pointPrice;
    }
}