package com.ellabook.entity.book;

import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;

/**
 * @author 
 * 
 */
@Data
@NoArgsConstructor
@ToString
public class BorrowBooksCard implements Serializable {
    /**
     * 主键id
     */
    private Integer id;

    /**
     * 序号（10000 + id）
     */
    private Integer indexId;

    /**
     * 激活码
     */
    private String cardCode;

    /**
     * 状态   UNASSIGNED:未分配  DISTRIBUTION:已分配 USED:已使用
     */
    private String status;

    /**
     * 创建时间
     */
    private Date createTime;


    /**
     * 使用时间
     */
    private Date useTime;

    /**
     * 使用用户uId
     */
    private String userId;

    /**
     * 送书活动ID
     */
    private String eventId;

    /**
     * 激活天数
     */
    private Integer activeTime;

    /**
     * 备注（预留字段）
     */
    private String remark;

    /**
     * 批次编码
     */
    private String batch;

    private static final long serialVersionUID = 1L;


    public BorrowBooksCard(Date createTime, Integer activeTime, String eventId) {
        this.createTime = createTime;
        this.activeTime = activeTime;
        this.eventId = eventId;
    }
}