package com.ellabook.entity.book;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
public class BookSeries {
    private Long id;

    private String seriesCode;

    private String seriesName;

    private String bookIntroduction;

    private String coverResource;

    private BigDecimal bookScore;

    private Integer scoreNum;

    private String tags;

    private String seriesType;

    private Integer bookletNum;

    private String bookletType;

    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateTime;

    private String shelvesFlag;

    private String status;

    private String keyword;

    private Integer bookNum;

    private List<BookSeriesRelation> books;

    private List<BookSeriesPreviewResource> resources;
}