package com.ellabook.entity.book;

import com.ellabook.util.doc.annotations.FieldExplain;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.NoArgsConstructor;

import java.util.Date;

@Builder
@AllArgsConstructor
public class BookResource {
    @FieldExplain(explain = "自增主键")
    private Long id;

    @FieldExplain(explain = "资源编码")
    private String resourceCode;

    @FieldExplain(explain = "资源名称")
    private String resourceName;

    @FieldExplain(explain = "书籍编码")
    private String bookCode;

    @FieldExplain(explain = "模式类型  BOOK_COVER:图书封面,BOOK_TRY_READ:试读")
    private String resourceType;

    @FieldExplain(explain = "设备型号")
    private String resource;

    @FieldExplain(explain = "oss bucket")
    private String ossBucket;

    @FieldExplain(explain = "oss key")
    private String ossKey;

    @FieldExplain(explain = "url")
    private String ossUrl;

    @FieldExplain(explain = "可用状态 EXCEPTION:不可用 ,NORMAL:可用")
    private String status;

    @FieldExplain(explain = "是否默认资源 DEFAULT_NO:否 ,DEFAULT_YES:是")
    private String isDefault;

    @FieldExplain(explain = "资源版本")
    private String resourceVersion;

    @FieldExplain(explain = "创建时间")
    private Date createTime;

    @FieldExplain(explain = "修改时间")
    private Date updateTime;

    @FieldExplain(explain = "创建人")
    private String createBy;

    @FieldExplain(explain = "修改人")
    private String updateBy;

    public BookResource() {
    }

    public BookResource(String bookCode, String resourceType, String resource, String ossBucket, String ossKey, String ossUrl, String status, String isDefault, String resourceVersion, Date createTime, Date updateTime, String createBy, String updateBy) {
        this.bookCode = bookCode;
        this.resourceType = resourceType;
        this.resource = resource;
        this.ossBucket = ossBucket;
        this.ossKey = ossKey;
        this.ossUrl = ossUrl;
        this.status = status;
        this.isDefault = isDefault;
        this.resourceVersion = resourceVersion;
        this.createTime = createTime;
        this.updateTime = updateTime;
        this.createBy = createBy;
        this.updateBy = updateBy;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getResourceCode() {
        return resourceCode;
    }

    public void setResourceCode(String resourceCode) {
        this.resourceCode = resourceCode == null ? null : resourceCode.trim();
    }

    public String getResourceName() {
        return resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName == null ? null : resourceName.trim();
    }

    public String getBookCode() {
        return bookCode;
    }

    public void setBookCode(String bookCode) {
        this.bookCode = bookCode == null ? null : bookCode.trim();
    }

    public String getResourceType() {
        return resourceType;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType == null ? null : resourceType.trim();
    }

    public String getResource() {
        return resource;
    }

    public void setResource(String resource) {
        this.resource = resource == null ? null : resource.trim();
    }

    public String getOssBucket() {
        return ossBucket;
    }

    public void setOssBucket(String ossBucket) {
        this.ossBucket = ossBucket == null ? null : ossBucket.trim();
    }

    public String getOssKey() {
        return ossKey;
    }

    public void setOssKey(String ossKey) {
        this.ossKey = ossKey == null ? null : ossKey.trim();
    }

    public String getOssUrl() {
        return ossUrl;
    }

    public void setOssUrl(String ossUrl) {
        this.ossUrl = ossUrl == null ? null : ossUrl.trim();
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getIsDefault() {
        return isDefault;
    }

    public void setIsDefault(String isDefault) {
        this.isDefault = isDefault;
    }

    public String getResourceVersion() {
        return resourceVersion;
    }

    public void setResourceVersion(String resourceVersion) {
        this.resourceVersion = resourceVersion == null ? null : resourceVersion.trim();
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public String getCreateBy() {
        return createBy;
    }

    public void setCreateBy(String createBy) {
        this.createBy = createBy == null ? null : createBy.trim();
    }

    public String getUpdateBy() {
        return updateBy;
    }

    public void setUpdateBy(String updateBy) {
        this.updateBy = updateBy == null ? null : updateBy.trim();
    }
}