package com.ellabook.entity.book;

import com.ellabook.util.doc.annotations.FieldExplain;

import java.util.Date;

public class BookModeResource {

    @FieldExplain(explain = "自增主键")
    private Long id;

    @FieldExplain(explain = "资源编码")
    private String modeCode;

    @FieldExplain(explain = "书籍编码")
    private String bookCode;

    @FieldExplain(explain = "模式类型  BOOK_FORMAL:正式版")
    private String modeType;

    @FieldExplain(explain = "设备型号")
    private String resource;

    @FieldExplain(explain = "oss bucket")
    private String ossBucket;

    @FieldExplain(explain = "oss key")
    private String ossKey;

    @FieldExplain(explain = "url")
    private String ossUrl;

    @FieldExplain(explain = "secret oss bucket")
    private String secretOssBucket;

    @FieldExplain(explain = "secret oss key")
    private String secretOssKey;

    @FieldExplain(explain = "secret url")
    private String secretOssUrl;

    @FieldExplain(explain = "加密资源包文件索引")
    private String packageIndex;

    @FieldExplain(explain = "可用状态 EXCEPTION:不可用 ,NORMAL:可用")
    private String status;

    @FieldExplain(explain = "是否默认资源 DEFAULT_NO:否 ,DEFAULT_YES:是")
    private String isDefault;

    @FieldExplain(explain = "资源版本")
    private String resourceVersion;

    @FieldExplain(explain = "阅读器版本")
    private String readerVersion;

    @FieldExplain(explain = "资源更新类型：UPDATE_SUGGEST：建议更新，UPDATE_FORCED：强制更新，UPDATE_MATCH：匹配更新")
    private String updateType;

    @FieldExplain(explain = "创建时间")
    private Date createTime;

    @FieldExplain(explain = "修改时间")
    private Date updateTime;

    @FieldExplain(explain = "创建人")
    private String createBy;

    @FieldExplain(explain = "修改人")
    private String updateBy;

    @FieldExplain(explain = "资源大小，单位为M")
    private String modeResourceSize;

    @FieldExplain(explain = "资源字节数")
    private Long resourceBytes;

    @FieldExplain(explain = "md5")
    private String md5;

    @FieldExplain(explain = "md5")
    private String secretMd5;

    private String bookResourceMD5;

    public BookModeResource() {
    }

    public BookModeResource(String bookCode, String modeType, String resource, String ossBucket, String ossKey, String ossUrl, String modeResourceSize, String status, String isDefault, String resourceVersion, Date createTime, Date updateTime, String createBy, String updateBy) {
        this.bookCode = bookCode;
        this.modeType = modeType;
        this.resource = resource;
        this.ossBucket = ossBucket;
        this.ossKey = ossKey;
        this.ossUrl = ossUrl;
        this.modeResourceSize = modeResourceSize;
        this.status = status;
        this.isDefault = isDefault;
        this.resourceVersion = resourceVersion;
        this.createTime = createTime;
        this.updateTime = updateTime;
        this.createBy = createBy;
        this.updateBy = updateBy;
    }

    public Long getResourceBytes() {
        return resourceBytes;
    }

    public void setResourceBytes(Long resourceBytes) {
        this.resourceBytes = resourceBytes;
    }

    public String getReaderVersion() {
        return readerVersion;
    }

    public void setReaderVersion(String readerVersion) {
        this.readerVersion = readerVersion;
    }

    public String getUpdateType() {
        return updateType;
    }

    public void setUpdateType(String updateType) {
        this.updateType = updateType;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getModeCode() {
        return modeCode;
    }

    public void setModeCode(String modeCode) {
        this.modeCode = modeCode == null ? null : modeCode.trim();
    }

    public String getBookCode() {
        return bookCode;
    }

    public void setBookCode(String bookCode) {
        this.bookCode = bookCode == null ? null : bookCode.trim();
    }

    public String getModeType() {
        return modeType;
    }

    public void setModeType(String modeType) {
        this.modeType = modeType == null ? null : modeType.trim();
    }

    public String getResource() {
        return resource;
    }

    public void setResource(String resource) {
        this.resource = resource == null ? null : resource.trim();
    }

    public String getOssBucket() {
        return ossBucket;
    }

    public void setOssBucket(String ossBucket) {
        this.ossBucket = ossBucket == null ? null : ossBucket.trim();
    }

    public String getOssKey() {
        return ossKey;
    }

    public void setOssKey(String ossKey) {
        this.ossKey = ossKey == null ? null : ossKey.trim();
    }

    public String getOssUrl() {
        return ossUrl;
    }

    public void setOssUrl(String ossUrl) {
        this.ossUrl = ossUrl == null ? null : ossUrl.trim();
    }

    public String getModeResourceSize() {
        return modeResourceSize;
    }

    public void setModeResourceSize(String modeResourceSize) {
        this.modeResourceSize = modeResourceSize;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getIsDefault() {
        return isDefault;
    }

    public void setIsDefault(String isDefault) {
        this.isDefault = isDefault;
    }

    public String getResourceVersion() {
        return resourceVersion;
    }

    public void setResourceVersion(String resourceVersion) {
        this.resourceVersion = resourceVersion == null ? null : resourceVersion.trim();
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public String getCreateBy() {
        return createBy;
    }

    public void setCreateBy(String createBy) {
        this.createBy = createBy == null ? null : createBy.trim();
    }

    public String getUpdateBy() {
        return updateBy;
    }

    public void setUpdateBy(String updateBy) {
        this.updateBy = updateBy == null ? null : updateBy.trim();
    }

    public String getMd5() {
        return md5;
    }

    public void setMd5(String md5) {
        this.md5 = md5;
    }

    public String getBookResourceMD5() {
        return bookResourceMD5;
    }

    public void setBookResourceMD5(String bookResourceMD5) {
        this.bookResourceMD5 = bookResourceMD5;
    }

    public String getSecretOssBucket() {
        return secretOssBucket;
    }

    public void setSecretOssBucket(String secretOssBucket) {
        this.secretOssBucket = secretOssBucket;
    }

    public String getSecretOssKey() {
        return secretOssKey;
    }

    public void setSecretOssKey(String secretOssKey) {
        this.secretOssKey = secretOssKey;
    }

    public String getSecretOssUrl() {
        return secretOssUrl;
    }

    public void setSecretOssUrl(String secretOssUrl) {
        this.secretOssUrl = secretOssUrl;
    }

    public String getSecretMd5() {
        return secretMd5;
    }

    public void setSecretMd5(String secretMd5) {
        this.secretMd5 = secretMd5;
    }

    public String getPackageIndex() {
        return packageIndex;
    }

    public void setPackageIndex(String packageIndex) {
        this.packageIndex = packageIndex;
    }
}