package com.ellabook.entity.book;

import com.ellabook.util.parameterChecking.NotBlank;

import java.util.Date;
import java.util.List;

/**
 * Description:    课程表
 * Author:         lyy
 * CreateDate:     2018/6/5 18:35
 */
public class BookCourse {
    private Long id;
    private String courseCode;//课程唯一编码
    @NotBlank(value = "课程名称不能为空")
    private String courseName;//课程名称
    @NotBlank(value = "课程描述不能为空")
    private String courseDesc;//课程描述
    @NotBlank(value = "封面图片不能为空")
    private String coverImageUrl;//封面图片
    @NotBlank(value = "课程背景图片不能为空")
    private String bgImageUrl;//课程背景图片
    private String graphicIntroduction;//图文描述
    @NotBlank(value = "图书描述跳转地址不能为空")
    private String targetPage;//图书描述跳转地址
    private String courseLimit;//课程限定   顺序上锁：LOCK_YES，不上锁：LOCK_NO
    private String courseLabel;//课程标签   HOT：最热， NEW：最新'
    private Integer classHour;//课时
    private Integer booksNum;//包含图书
    private Date createTime;
    private Date updateTime;
    private String status;//可用状态 EXCEPTION:不可用, NORMAL:可用
    private Integer idx;//排序
    private List<BookCourseChapter> bookCourseChapters;//单元list
    private List<CoursePreviewResource> coursePreviewResourceList;//课程预览内容资源

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCourseCode() {
        return courseCode;
    }

    public void setCourseCode(String courseCode) {
        this.courseCode = courseCode;
    }

    public String getCourseName() {
        return courseName;
    }

    public void setCourseName(String courseName) {
        this.courseName = courseName;
    }

    public String getCourseDesc() {
        return courseDesc;
    }

    public void setCourseDesc(String courseDesc) {
        this.courseDesc = courseDesc;
    }

    public String getBgImageUrl() {
        return bgImageUrl;
    }

    public void setBgImageUrl(String bgImageUrl) {
        this.bgImageUrl = bgImageUrl;
    }

    public String getGraphicIntroduction() {
        return graphicIntroduction;
    }

    public void setGraphicIntroduction(String graphicIntroduction) {
        this.graphicIntroduction = graphicIntroduction;
    }

    public String getTargetPage() {
        return targetPage;
    }

    public void setTargetPage(String targetPage) {
        this.targetPage = targetPage;
    }

    public String getCourseLimit() {
        return courseLimit;
    }

    public void setCourseLimit(String courseLimit) {
        this.courseLimit = courseLimit;
    }

    public String getCourseLabel() {
        return courseLabel;
    }

    public void setCourseLabel(String courseLabel) {
        this.courseLabel = courseLabel;
    }

    public Integer getClassHour() {
        return classHour;
    }

    public void setClassHour(Integer classHour) {
        this.classHour = classHour;
    }

    public Integer getBooksNum() {
        return booksNum;
    }

    public void setBooksNum(Integer booksNum) {
        this.booksNum = booksNum;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Integer getIdx() {
        return idx;
    }

    public void setIdx(Integer idx) {
        this.idx = idx;
    }

    public List<BookCourseChapter> getBookCourseChapters() {
        return bookCourseChapters;
    }

    public void setBookCourseChapters(List<BookCourseChapter> bookCourseChapters) {
        this.bookCourseChapters = bookCourseChapters;
    }

    public String getCoverImageUrl() {
        return coverImageUrl;
    }

    public void setCoverImageUrl(String coverImageUrl) {
        this.coverImageUrl = coverImageUrl;
    }

    public List<CoursePreviewResource> getCoursePreviewResourceList() {
        return coursePreviewResourceList;
    }

    public void setCoursePreviewResourceList(List<CoursePreviewResource> coursePreviewResourceList) {
        this.coursePreviewResourceList = coursePreviewResourceList;
    }
}
