package com.ellabook.entity.book;

import org.hibernate.validator.constraints.NotEmpty;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.Pattern;
import java.util.Date;

public class BookComment {
    private Integer id;
    private String commentCode;
    @NotEmpty
    private String bookCode;
    @NotEmpty
    private String uid;
    private String commentTitle;
    @NotEmpty
    private String commentContent;//评论内容
    private String commentVoiceUrl;  //评论语音地址
    private String commentDuration;  //语音评论时长
    @Range(min = 1, max = 5)
    private Integer commentScore;  //评分 1-5
    private Date commentTime;//评论时间
    @Pattern(regexp = "^[REAL_NAME]|[ANONYMOUS_YES]$", message = "是否匿名参数传递错误")
    private String isAnonymous;//是否匿名: REAL_NAME:实名 ,ANONYMOUS_YES:匿名
    private Integer upvoteNum;//点赞数
    @Pattern(regexp = "^[COMMENT_TEXT]|[COMMENT_VOICE]$", message = "评论类型参数传递错误")
    private String commentType;//评论类型： COMMENT_TEXT:文字评论,COMMENT_VOICE:语音评论
    private String userNick;//昵称
    private String userAvatar;//用户头像url
    private Integer commentCount;
    private String status;
    private String isSelected;

    public BookComment() {
    }

    public BookComment(String commentCode, String bookCode, String uid, String commentTitle, String commentContent, String commentVoiceUrl,
                       String commentDuration, Integer commentScore, Date commentTime, String isAnonymous, Integer upvoteNum, String commentType,
                       String status) {
        this.commentCode = commentCode;
        this.bookCode = bookCode;
        this.uid = uid;
        this.commentTitle = commentTitle;
        this.commentContent = commentContent;
        this.commentVoiceUrl = commentVoiceUrl;
        this.commentDuration = commentDuration;
        this.commentScore = commentScore;
        this.commentTime = commentTime;
        this.isAnonymous = isAnonymous;
        this.upvoteNum = upvoteNum;
        this.commentType = commentType;
        this.status = status;
    }

    public Integer getCommentCount() {
        return commentCount;
    }

    public void setCommentCount(Integer commentCount) {
        this.commentCount = commentCount;
    }

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getCommentCode() {
        return commentCode;
    }

    public void setCommentCode(String commentCode) {
        this.commentCode = commentCode;
    }

    public String getBookCode() {
        return bookCode;
    }

    public void setBookCode(String bookCode) {
        this.bookCode = bookCode;
    }

    public String getUid() {
        return uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public String getCommentTitle() {
        return commentTitle;
    }

    public void setCommentTitle(String commentTitle) {
        this.commentTitle = commentTitle;
    }

    public String getCommentContent() {
        return commentContent;
    }

    public void setCommentContent(String commentContent) {
        this.commentContent = commentContent;
    }

    public String getCommentVoiceUrl() {
        return commentVoiceUrl;
    }

    public void setCommentVoiceUrl(String commentVoiceUrl) {
        this.commentVoiceUrl = commentVoiceUrl;
    }

    public String getCommentDuration() {
        return commentDuration;
    }

    public void setCommentDuration(String commentDuration) {
        this.commentDuration = commentDuration;
    }

    public Integer getCommentScore() {
        return commentScore;
    }

    public void setCommentScore(Integer commentScore) {
        this.commentScore = commentScore;
    }

    public Date getCommentTime() {
        return commentTime;
    }

    public void setCommentTime(Date commentTime) {
        this.commentTime = commentTime;
    }

    public String getIsAnonymous() {
        return isAnonymous;
    }

    public void setIsAnonymous(String isAnonymous) {
        this.isAnonymous = isAnonymous;
    }

    public Integer getUpvoteNum() {
        return upvoteNum;
    }

    public void setUpvoteNum(Integer upvoteNum) {
        this.upvoteNum = upvoteNum;
    }

    public String getCommentType() {
        return commentType;
    }

    public void setCommentType(String commentType) {
        this.commentType = commentType;
    }

    public String getUserNick() {
        return userNick;
    }

    public void setUserNick(String userNick) {
        this.userNick = userNick;
    }

    public String getUserAvatar() {
        return userAvatar;
    }

    public void setUserAvatar(String userAvatar) {
        this.userAvatar = userAvatar;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getIsSelected() {
        return isSelected;
    }

    public void setIsSelected(String isSelected) {
        this.isSelected = isSelected;
    }
}