package com.ellabook.entity.book;

import com.ellabook.util.doc.annotations.FieldExplain;

import java.math.BigDecimal;
import java.util.Date;

public class BaseBook {
    private Long id;
    @FieldExplain(explain = "图书编码(如：B201801190001)")
    private String bookCode;
    @FieldExplain(explain = "图书系列名(如：动态阅读)")
    private String bookSeriesName;
    @FieldExplain(explain = "图书名称(如：动态阅读2-3彩色世界)")
    private String bookName;
    @FieldExplain(explain = "图书适用年龄的起始值(如：0)")
    private Integer bookStartAge;
    @FieldExplain(explain = "图书适用年龄的终止值(如：3)")
    private Integer bookEndAge;
    @FieldExplain(explain = "图书页数(如：15)")
    private Integer bookPages;
    @FieldExplain(explain = "图书简介(如：兔奶奶有一件特别漂亮的.....)")
    private String bookIntroduction;
    @FieldExplain(explain = "图书资源大小，单位M(如：18.35)")
    private String bookSize;
    @FieldExplain(explain = "出版社编码(如：P20171031152443)")
    private String bookPressCode;
    @FieldExplain(explain = "出版社uid(如：U201801200100004)")
    private String bookPublish;
    @FieldExplain(explain = "图书评分(如：4.8)")
    private BigDecimal bookScore;
    @FieldExplain(explain = "评分人数(如：102)")
    private Integer scoreNum;
    @FieldExplain(explain = "下载次数(如：1256)")
    private Integer downloadNum;
    @FieldExplain(explain = "阅读人数(如：1558)")
    private Integer readNum;
    @FieldExplain(explain = "真实阅读人数(如：1036)")
    private Integer realReadNum;
    @FieldExplain(explain = "购买人数(如：356)")
    private Integer buyNum;
    @FieldExplain(explain = "`目前没有审核流程，该字段未使用`图书状态：BOOK_NOT_VERIFY:未审核，BOOK_IN_VERIFY:审核中，BOOK_HAS_VERIFY:已审核(如：BOOK_NOT_VERIFY)")
    private String bookStatus;
    @FieldExplain(explain = "图书名称的拼音(如：DTYD7-2XFYFS)")
    private String pinyin;
    @FieldExplain(explain = "是否会员借阅 VIP_NO-否 VIP_YES-是(如：VIP_NO)")
    private String isVip;
    @FieldExplain(explain = "图书标签(如：原创,嫦娥,后裔,月饼,月亮,神仙,思维......)")
    private String tags;
    @FieldExplain(explain = "书籍模式：BOOK_PLAY:玩书，BOOK_READ:看书,BOOK_LISTEN:听书,BOOK_MAKE:做书,BOOK_PARENTING:亲子，BOOK_DUB:配音(如：BOOK_PLAY,BOOK_READ)")
    private String bookMode;
    @FieldExplain(explain = "图书首次上传/创建时间，客户端的返回为时间戳(如：2016-01-12 18:55:33=1452596133000)")
    private Date createTime;
    @FieldExplain(explain = "图书信息修改时间，客户端的返回为时间戳(如：2016-01-12 18:55:33=1452596133000)")
    private Date updateTime;
    @FieldExplain(explain = "家园用书状态：YES:可用 NO：不可用(如：NO)")
    private String homeStatus;
    @FieldExplain(explain = "英语用书状态：YES:可用 NO：不可用(如：NO)")
    private String englishStatus;
    @FieldExplain(explain = "可用状态 EXCEPTION:不可用, NORMAL:可用(如：NORMAL)")
    private String status;
    @FieldExplain(explain = "语言：CHINESE：中文 ENGLISH：英文 PINYIN:中文带拼音 CHINSES_ENGLISH：中英双语(如：CHINESE)")
    private String language;
    @FieldExplain(explain = "图书上下架状态,与商品上下架状态保持一致  SHELVES_ON :上架 ,SHELVES_OFF :下架(如：SHELVES_ON)")
    private String shelvesFlag;
    @FieldExplain(explain = "图书版本号(如：2.0.1)")
    private String versionNumber;
    @FieldExplain(explain = "图书版本修改时间(如：如：2016-01-12 18:55:33=1452596133000)")
    private Date versionUpdateTime;
    @FieldExplain(explain = "图书版本有效期开始时间，客户端的返回为时间戳(如：2016-01-12=1452528000000)")
    private Date copyrightValidityStart;
    @FieldExplain(explain = "图书版本有效期终止时间，客户端的返回为时间戳(如：2016-01-12=1452528000000)")
    private Date copyrightValidityEnd;
    @FieldExplain(explain = "版权上下架状态  SHELVES_ON :已上架 ,SHELVES_OFF :已下架,HAVE_EXPIRED:已到期,HAVE_NOT_STARTED:未开始(如：SHELVES_ON)")
    private String copyrightStatus;
    @FieldExplain(explain = "运营文案")
    private String operatingCopywriter;
    @FieldExplain(explain = "核心标签")
    private String coreTags;
    @FieldExplain(explain = "是否高级会员 VIP_NO-否 VIP_YES-是(如：VIP_NO)")
    private String isSvip;
    @FieldExplain(explain = "伴读模式限定用户: ALL_USERS:全部用户， VIP_USERS:会员用户，SVIP_USERS:超级会员用户")
    private String bookModeAccompanyUsers;
    @FieldExplain(explain = "题目书")
    private Integer questionNumber;
    @FieldExplain(explain = "游戏页数")
    private Integer gamePages;
    @FieldExplain(explain = "家园免费书籍（YES/NO）")
    private String homeFree;
    @FieldExplain(explain = "图书每页信息 json对象字符串")
    private String pages;

    public String getIsSvip() {
        return isSvip;
    }

    public void setIsSvip(String isSvip) {
        this.isSvip = isSvip;
    }

    public String getBookModeAccompanyUsers() {
        return bookModeAccompanyUsers;
    }

    public void setBookModeAccompanyUsers(String bookModeAccompanyUsers) {
        this.bookModeAccompanyUsers = bookModeAccompanyUsers;
    }

    public String getOperatingCopywriter() {
        return operatingCopywriter;
    }

    public void setOperatingCopywriter(String operatingCopywriter) {
        this.operatingCopywriter = operatingCopywriter;
    }

    public String getCoreTags() {
        return coreTags;
    }

    public void setCoreTags(String coreTags) {
        this.coreTags = coreTags;
    }

    public String getCopyrightStatus() {
        return copyrightStatus;
    }

    public void setCopyrightStatus(String copyrightStatus) {
        this.copyrightStatus = copyrightStatus;
    }

    public String getVersionNumber() {
        return versionNumber;
    }

    public void setVersionNumber(String versionNumber) {
        this.versionNumber = versionNumber;
    }

    public Date getVersionUpdateTime() {
        return versionUpdateTime;
    }

    public void setVersionUpdateTime(Date versionUpdateTime) {
        this.versionUpdateTime = versionUpdateTime;
    }

    public Date getCopyrightValidityStart() {
        return copyrightValidityStart;
    }

    public void setCopyrightValidityStart(Date copyrightValidityStart) {
        this.copyrightValidityStart = copyrightValidityStart;
    }

    public Date getCopyrightValidityEnd() {
        return copyrightValidityEnd;
    }

    public void setCopyrightValidityEnd(Date copyrightValidityEnd) {
        this.copyrightValidityEnd = copyrightValidityEnd;
    }

    public Integer getRealReadNum() {
        return realReadNum;
    }

    public void setRealReadNum(Integer realReadNum) {
        this.realReadNum = realReadNum;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getBookCode() {
        return bookCode;
    }

    public void setBookCode(String bookCode) {
        this.bookCode = bookCode == null ? null : bookCode.trim();
    }

    public String getBookSeriesName() {
        return bookSeriesName;
    }

    public void setBookSeriesName(String bookSeriesName) {
        this.bookSeriesName = bookSeriesName == null ? null : bookSeriesName.trim();
    }

    public String getBookName() {
        return bookName;
    }

    public void setBookName(String bookName) {
        this.bookName = bookName == null ? null : bookName.trim();
    }

    public Integer getBookStartAge() {
        return bookStartAge;
    }

    public void setBookStartAge(Integer bookStartAge) {
        this.bookStartAge = bookStartAge;
    }

    public Integer getBookEndAge() {
        return bookEndAge;
    }

    public void setBookEndAge(Integer bookEndAge) {
        this.bookEndAge = bookEndAge;
    }

    public Integer getBookPages() {
        return bookPages;
    }

    public void setBookPages(Integer bookPages) {
        this.bookPages = bookPages;
    }

    public String getBookIntroduction() {
        return bookIntroduction;
    }

    public void setBookIntroduction(String bookIntroduction) {
        this.bookIntroduction = bookIntroduction == null ? null : bookIntroduction.trim();
    }

    public String getBookSize() {
        return bookSize;
    }

    public void setBookSize(String bookSize) {
        this.bookSize = bookSize == null ? null : bookSize.trim();
    }

    public String getBookPressCode() {
        return bookPressCode;
    }

    public void setBookPressCode(String bookPressCode) {
        this.bookPressCode = bookPressCode == null ? null : bookPressCode.trim();
    }

    public String getBookPublish() {
        return bookPublish;
    }

    public void setBookPublish(String bookPublish) {
        this.bookPublish = bookPublish == null ? null : bookPublish.trim();
    }

    public BigDecimal getBookScore() {
        return bookScore;
    }

    public void setBookScore(BigDecimal bookScore) {
        this.bookScore = bookScore;
    }

    public Integer getScoreNum() {
        return scoreNum;
    }

    public void setScoreNum(Integer scoreNum) {
        this.scoreNum = scoreNum;
    }

    public Integer getDownloadNum() {
        return downloadNum;
    }

    public void setDownloadNum(Integer downloadNum) {
        this.downloadNum = downloadNum;
    }

    public Integer getReadNum() {
        return readNum;
    }

    public void setReadNum(Integer readNum) {
        this.readNum = readNum;
    }

    public Integer getBuyNum() {
        return buyNum;
    }

    public void setBuyNum(Integer buyNum) {
        this.buyNum = buyNum;
    }

    public String getBookStatus() {
        return bookStatus;
    }

    public void setBookStatus(String bookStatus) {
        this.bookStatus = bookStatus == null ? null : bookStatus.trim();
    }

    public String getPinyin() {
        return pinyin;
    }

    public void setPinyin(String pinyin) {
        this.pinyin = pinyin == null ? null : pinyin.trim();
    }

    public String getIsVip() {
        return isVip;
    }

    public void setIsVip(String isVip) {
        this.isVip = isVip == null ? null : isVip.trim();
    }

    public String getTags() {
        return tags;
    }

    public void setTags(String tags) {
        this.tags = tags == null ? null : tags.trim();
    }

    public String getBookMode() {
        return bookMode;
    }

    public void setBookMode(String bookMode) {
        this.bookMode = bookMode == null ? null : bookMode.trim();
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status == null ? null : status.trim();
    }

    public String getLanguage() {
        return language;
    }

    public void setLanguage(String language) {
        this.language = language == null ? null : language.trim();
    }

    public String getHomeStatus() {
        return homeStatus;
    }

    public void setHomeStatus(String homeStatus) {
        this.homeStatus = homeStatus;
    }

    public String getShelvesFlag() {
        return shelvesFlag;
    }

    public void setShelvesFlag(String shelvesFlag) {
        this.shelvesFlag = shelvesFlag;
    }

    public String getEnglishStatus() {
        return englishStatus;
    }

    public void setEnglishStatus(String englishStatus) {
        this.englishStatus = englishStatus;
    }

    public Integer getQuestionNumber() {
        return questionNumber;
    }

    public void setQuestionNumber(Integer questionNumber) {
        this.questionNumber = questionNumber;
    }

    public Integer getGamePages() {
        return gamePages;
    }

    public void setGamePages(Integer gamePages) {
        this.gamePages = gamePages;
    }

    public String getHomeFree() {
        return homeFree;
    }

    public void setHomeFree(String homeFree) {
        this.homeFree = homeFree;
    }

    public String getPages() {
        return pages;
    }

    public void setPages(String pages) {
        this.pages = pages;
    }
}