package com.ellabook.entity.analysis.vo;

import com.ellabook.entity.analysis.dto.KeyValDataDTO;
import com.ellabook.util.BigDecimalUtil;
import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.math.BigDecimal;

/**
 * @Author: Ch
 * @Description:
 * @Date:Created 2018/9/13 19:43
 * @Modified By:
 */
@Setter
@NoArgsConstructor
@AllArgsConstructor
@JsonInclude(JsonInclude.Include.NON_NULL)
public class ChannelDataVO {
    @Getter
    private String channelName = "";
    @Getter
    private BigDecimal channelNum;
    @Getter
    private BigDecimal channelAmount;
    @Getter
    private Double channelRate;

    private KeyValDataDTO dto;

    public ChannelDataVO(String channelName, BigDecimal channelNum) {
        this.channelName = channelName;
        this.channelNum = channelNum;
    }

    public ChannelDataVO(KeyValDataDTO dto) {
        this.dto = dto;
        channelName = dto.getMsg();
        channelNum = dto.getValue();
    }

    public double compute(BigDecimal value, BigDecimal total) {
        double result = 0D;
        if (value == null || total == null || total.doubleValue() == 0D) {
        } else {
            result = BigDecimalUtil.div(BigDecimalUtil.mul(value, new BigDecimal(100)), total, 2).doubleValue();
        }
        channelRate = result;
        return result;
    }

    public String sortByDay() {
        return dto.getKey();
    }

}
