package com.ellabook.entity.analysis.dto;

import com.ellabook.entity.analysis.vo.ChannelDataVO;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.util.ArrayList;
import java.util.List;

/**
 * @Author: Ch
 * @Description:
 * @Date:Created 2018/9/13 15:42
 * @Modified By:
 */
//@Data
@Setter
@NoArgsConstructor
@AllArgsConstructor
public class UserSynopsisTotalDataDTO extends BaseUserSynopsisDataDTO {
    /************总用户*************/
    /**
     * 用户总数(含游客)
     */
//    @Getter
    private int totalUserNum;
//    /**
//     * 历史数据：对比用户总数
//     */
//    @Getter
//    private int compareTotalUserNum;
//    /**
//     * 用户增长率
//     */
////    @Getter
//    private double totalUserGrowthRate;
    /**
     * 总注册用户//
     */
    private int totalRegisterUserNum;
//    /**
//     * 总H5用户//
//     */
//    @Getter private  int totalH5UserNum;
    /**
     * 注册用户占比:占总用户
     */
    @Getter
    private double totalRegisterUserRate;
    /**
     * 游客用户占比：占总用户
     */
    @Getter
    private double totalGuestUserRate;
    /**
     * H5未激活用户//
     */
    private int h5NoActiveTotalUserNum;
    /**
     * H5未激活用户：占总用户
     */
    @Getter
    private double h5NoActiveTotalUserRate;
    /**
     * iOS用户//
     */
    private int iosTotalUserNum;
    /**
     * iOS用户占比：占总用户
     */
    @Getter
    private double iosTotalUserRate;
    /**
     * 安卓用户占比：占总用户
     */
    @Getter
    private double androidTotalUserRate;
    /**
     * 安卓各渠道用户占比：占总用户
     */
    @Getter
    private List<ChannelDataVO> channelTotalDataList = new ArrayList<>();
    /**
     * 只启动一次用户//
     */
    private int totalAppStartOnceUserNum;
    /**
     * 只启动一次用户占比：占总用户
     */
    @Getter
    private double totalAppStartOnceUserRate;
    /**
     * 后续有启动用户//
     */
    private int totalAppStartRepeatedlyUserNum;
    /**
     * 后续有启动用户占比：占总用户
     */
    @Getter
    private double totalAppStartRepeatedlyUserRate;
    /*************新增用户************/
    /**
     * 新增用户数量:当前新增
     */
//    @Getter
    private int increaseUserNum;

    public void compute() {
        if (totalUserNum <= 0) {
            return;
        }

//        游客（或注册用户/未激活用户）数量/累计用户总数*100%
        totalRegisterUserRate = percent(totalRegisterUserNum, totalUserNum);
        totalGuestUserRate = leftPercentScale(totalUserNum, totalRegisterUserNum);
        h5NoActiveTotalUserRate = percent(h5NoActiveTotalUserNum, totalUserNum);
        iosTotalUserRate = percent(iosTotalUserNum, totalUserNum);
        androidTotalUserRate = leftPercentScale(totalUserNum, iosTotalUserNum);

//        只启动一次用户数（启动次数≥2的用户数）,用户总数*100%
        totalAppStartOnceUserRate = percent(totalAppStartOnceUserNum, totalUserNum);
        totalAppStartRepeatedlyUserRate = percent(totalAppStartRepeatedlyUserNum, totalUserNum);
    }

}
