package com.ellabook.entity.analysis.dto;

import com.ellabook.entity.analysis.vo.ChannelDataVO;
import com.ellabook.util.BigDecimalUtil;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * @Author: Ch
 * @Description:
 * @Date:Created 2018/9/13 15:42
 * @Modified By:
 */
//@Data
@Setter
@NoArgsConstructor
@AllArgsConstructor
public class UserSynopsisPayAmountDataDTO extends BaseUserSynopsisDataDTO {
    /*************付费金额总数************/
    /**
     * 订单成交总金额
     */
    @Getter
    private BigDecimal totalPayAmount;
    /**
     * 历史数据：对比订单成交总金额
     */
//    @Getter
    private BigDecimal compareTotalPayAmount = BigDecimal.ZERO;
//    /**
//     * 付费金额变化率
//     */
//    @Getter
//    private double payAmountChangingRate;
    /**
     * 新增付费金额
     */
    @Getter
    private BigDecimal increasePayAmount = BigDecimal.ZERO;
    /**
     * 苹果内购金额占比
     */
    @Getter
    private double applePayAmountRate;
    /**
     * 安卓支付平台金额占比
     */
    @Getter
    private double androidPayPlatformAmountRate;
    /**
     * 微信支付金额占比
     */
    @Getter
    private double wxpayAmountRate;
    /**
     * 支付宝支付金额占比
     */
    @Getter
    private double alipayAmountRate;
    /**
     * 华为支付金额占比
     */
    @Getter
    private double huaweipayAmountRate;
    /**
     * 咿啦币支付金额占比
     */
    @Getter
    private double ellaCoinPayAmountRate;

    private BigDecimal applePayAmount = BigDecimal.ZERO;
    private BigDecimal wxpayAmount = BigDecimal.ZERO;
    private BigDecimal alipayAmount = BigDecimal.ZERO;
    private BigDecimal huaweipayAmount = BigDecimal.ZERO;
    private BigDecimal ellaCoinPayAmount = BigDecimal.ZERO;
    /**
     * iOS付费金额
     */
    private BigDecimal iosPayAmount;
    /**
     * iOS付费占比：占付费金额
     */
    @Getter
    private double iosPayAmountRate;
    /**
     * 安卓付费占比：占付费金额
     */
    @Getter
    private double androidPayAmountRate;
    /**
     * 安卓各渠道占比：占付费金额
     */
    @Getter
    private List<ChannelDataVO> channelPayAmountDataList = new ArrayList<>();
    /**
     * 生成订单数
     */
    @Getter
    private int totalOrderNum;
    /**
     * 完成订单数
     */
    @Getter
    private int totalPayedOrderNum;
    /**
     * 订单完成率
     */
    @Getter
    private double payOrderFinishingRate;
    /**
     * 充值咿啦币金额//
     */
    private BigDecimal totalRechargeAmount;
    /**
     * 购买会员金额//
     */
    private BigDecimal totalMemberBuyAmount;
    /**
     * 充值咿啦币占比：占付费金额
     */
    @Getter
    private double rechargeAmountRate;
    /**
     * 购买会员占比：占付费金额
     */
    @Getter
    private double memberBuyAmountRate;


    public void compute() {
        if (totalPayAmount == null) {
            return;
        }
//        新增付费用户数/本时间段付费用户总数*100%
        increasePayAmount = totalPayAmount.subtract(compareTotalPayAmount);
//        支付方式金额/付费总金额*100%
        applePayAmountRate = percent(applePayAmount, totalPayAmount);
        wxpayAmountRate = percent(wxpayAmount, totalPayAmount);
        alipayAmountRate = percent(alipayAmount, totalPayAmount);
        huaweipayAmountRate = percent(huaweipayAmount, totalPayAmount);
        ellaCoinPayAmountRate = percent(ellaCoinPayAmount, totalPayAmount);
        androidPayPlatformAmountRate = percent(BigDecimalUtil.add(BigDecimalUtil.add(wxpayAmount, alipayAmount), ellaCoinPayAmount), totalPayAmount);
        iosPayAmountRate = percent(iosPayAmount, totalPayAmount);
        androidPayAmountRate = leftPercentScale(totalPayAmount.doubleValue(), iosPayAmount.doubleValue());
        payOrderFinishingRate = percent(totalPayedOrderNum, totalOrderNum);
//        咿啦币（会员）订单金额/总付费金额*100%
        rechargeAmountRate = percent(totalRechargeAmount, totalPayAmount);
        memberBuyAmountRate = percent(totalMemberBuyAmount, totalPayAmount);
    }

}
