package com.ellabook.entity.analysis.dto;

import com.ellabook.entity.analysis.vo.ChannelDataVO;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.util.ArrayList;
import java.util.List;

/**
 * @Author: Ch
 * @Description:
 * @Date:Created 2018/9/13 15:42
 * @Modified By:
 */
//@Data
@Setter
@NoArgsConstructor
@AllArgsConstructor
public class UserSynopsisIncreaseDataDTO extends BaseUserSynopsisDataDTO {
    /*************新增用户************/
    /**
     * 新增用户数量:当前新增
     */
    @Getter
    private int increaseUserNum;
//    /**
//     * 历史数据：对比新增用户数
//     */
//    @Getter
//    private int compareIncreaseUserNum;
//    /**
//     * 增长人数变化率
//     */
//    @Getter
//    private double increaseUserChangingRate;
    /**
     * 当前注册新增//
     */
    private int increaseRegisterUserNum;
    /**
     * 新增游客用户
     */
    @Getter
    private double increaseGuestUserRate;
    /**
     * 新增注册用户
     */
    @Getter
    private double increaseRegisterUserRate;
//    @Getter private  List<String> listIncreaseH5User;
    /**
     * 新增H5未激活用户//
     */
    private double h5NoActiveIncreaseUserNum;
    /**
     * 新增H5未激活用户：占新增用户
     */
    @Getter
    private double h5NoActiveIncreaseUserRate;
    /**
     * 新增iOS新增用户
     */
    private int iosIncreaseNum;
    /**
     * 新增iOS用户占比：占新增用户
     */
    @Getter
    private double iosIncreaseUserRate;
    /**
     * 新增安卓用户占比：占新增用户
     */
    @Getter
    private double androidIncreaseUserRate;
    /**
     * 安卓各渠道用户占比：占新增用户
     */
    @Getter
    private List<ChannelDataVO> channelIncreaseDataList = new ArrayList<>();
    /**
     * 只启动一次用户//
     */
    private double increaseAppStartOnceUserNum;
    /**
     * 只启动一次用户占比：占新增用户
     */
    @Getter
    private double increaseAppStartOnceUserRate;
    /**
     * 后续有启动用户//
     */
    private double increaseAppStartRepeatedlyUserNum;
    /**
     * 后续有启动用户占比：占新增用户
     */
    @Getter
    private double increaseAppStartRepeatedlyUserRate;
//    /**
//     * 注册未启动//
//     */
//    private double increaseAppNoStartUserNum;
    /**
     * 注册未启动占比：占新增用户
     */
    @Getter
    private double increaseAppNoStartUserRate;

    public void compute() {
        if (increaseUserNum <= 0) {
            return;
        }

//        游客（注册用户，未激活用户）数量/新增用户数*100%
        increaseRegisterUserRate = percent(increaseRegisterUserNum, increaseUserNum);
        increaseGuestUserRate = leftPercentScale(increaseUserNum, increaseRegisterUserNum);
        h5NoActiveIncreaseUserRate = percent(h5NoActiveIncreaseUserNum, increaseUserNum);
        iosIncreaseUserRate = percent(iosIncreaseNum, increaseUserNum);
        androidIncreaseUserRate = leftPercentScale(increaseUserNum, iosIncreaseNum);

//        只启动一次用户数（启动次数≥2的用户数）/新增用户数*100%
        increaseAppStartOnceUserRate = percent(increaseAppStartOnceUserNum, increaseUserNum);
        increaseAppStartRepeatedlyUserRate = percent(increaseAppStartRepeatedlyUserNum, increaseUserNum);
        increaseAppNoStartUserRate = leftPercentScale(increaseUserNum, increaseAppStartOnceUserNum + increaseAppStartRepeatedlyUserNum);
    }

}
