package com.ellabook.entity.analysis.dto;

import com.ellabook.entity.analysis.vo.ChannelDataVO;
import com.ellabook.util.BigDecimalUtil;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * @Author: Ch
 * @Description:
 * @Date:Created 2018/9/13 15:42
 * @Modified By:
 */
//@Data
@Setter
@NoArgsConstructor
@AllArgsConstructor
public class UserSynopsisDataDTO extends BaseUserSynopsisDataDTO {
    /************总用户*************/
    /**
     * 用户总数(含游客)
     */
    @Getter
    private int totalUserNum;
    /**
     * 历史数据：对比用户总数
     */
    @Getter
    private int compareTotalUserNum;
    /**
     * 用户增长率
     */
    @Getter
    private double totalUserGrowthRate;
//    /**
//     * 总注册用户//
//     */
//    private int totalRegisterUserNum;
//    /**
//     * 总H5用户//
//     */
//    @Getter private  int totalH5UserNum;
    /**
     * 注册用户占比:占总用户
     */
    @Getter
    private double totalRegisterUserRate;
    /**
     * 游客用户占比：占总用户
     */
    @Getter
    private double totalGuestUserRate;
//    /**
//     * H5未激活用户//
//     */
//    private int h5NoActiveTotalUserNum;
    /**
     * H5未激活用户：占总用户
     */
    @Getter
    private double h5NoActiveTotalUserRate;
//    /**
//     * iOS用户//
//     */
//    private int iosTotalUserNum;
    /**
     * iOS用户占比：占总用户
     */
    @Getter
    private double iosTotalUserRate;
    /**
     * 安卓用户占比：占总用户
     */
    @Getter
    private double androidTotalUserRate;
    /**
     * 安卓各渠道用户占比：占总用户
     */
    @Getter
    private List<ChannelDataVO> channelTotalDataList = new ArrayList<>();
//    /**
//     * 只启动一次用户//
//     */
//    private int totalAppStartOnceUserNum;
    /**
     * 只启动一次用户占比：占总用户
     */
    @Getter
    private double totalAppStartOnceUserRate;
//    /**
//     * 后续有启动用户//
//     */
//    private int totalAppStartRepeatedlyUserNum;
    /**
     * 后续有启动用户占比：占总用户
     */
    @Getter
    private double totalAppStartRepeatedlyUserRate;
    /*************新增用户************/
    /**
     * 新增用户数量:当前新增
     */
    @Getter
    private int increaseUserNum;
    /**
     * 历史数据：对比新增用户数
     */
    @Getter
    private int compareIncreaseUserNum;
    /**
     * 增长人数变化率
     */
    @Getter
    private double increaseUserChangingRate;
    /*************活跃用户************/
    /**
     * 活跃用户数
     */
    @Getter
    private int activeUserNum;
    /**
     * 历史数据：对比活跃用户数
     */
    @Getter
    private int compareActiveUserNum;
    /**
     * 活跃用户变化率
     */
    @Getter
    private double activeUserChangingRate;
    /*************付费用户************/
    /**
     * 付费用户数
     */
    @Getter
    private int totalPayUserNum;
    /**
     * 历史数据：对比付费用户数
     */
    @Getter
    private int compareTotalPayUserNum;
    /**
     * 付费用户变化率
     */
    @Getter
    private double payUserChangingRate;
    /**
     * 新增付费用户数
     */
//    @Getter
    private int firstPayUserNum;
    /*************付费金额总数************/
    /**
     * 订单成交总金额
     */
    @Getter
    private BigDecimal totalPayAmount = BigDecimal.ZERO;
    /**
     * 历史数据：对比订单成交总金额
     */
    @Getter
    private BigDecimal compareTotalPayAmount;
    /**
     * 付费金额变化率
     */
    @Getter
    private double payAmountChangingRate;

    public void compute() {
        increaseUserNum = totalUserNum - compareTotalUserNum;
//        新增用户数/本时间段用户总数*100%
        totalUserGrowthRate = percent(increaseUserNum, totalUserNum);

//        本时间用户增长率-上时间段用户增长率
        increaseUserChangingRate = percent(increaseUserNum - compareIncreaseUserNum, increaseUserNum);

//        （本时间段活跃用户/本时间段用户总数-上时间段活跃用户/上时间段总用户数）*100%
        activeUserChangingRate = percent(activeUserNum - compareActiveUserNum, activeUserNum);
        double firstPayUserRate = percent(firstPayUserNum, totalPayUserNum);
//        新增付费用户数/本时间段付费用户总数*100%
        payUserChangingRate = firstPayUserRate;

//        本时间付费金额-上时间付费金额/本时间付费金额*100%
        if (totalPayAmount != null && compareTotalPayAmount != null && totalPayAmount.doubleValue() > 0) {
            payAmountChangingRate = percent(BigDecimalUtil.sub(totalPayAmount, compareTotalPayAmount), totalPayAmount);
        }
    }


}