package com.ellabook.entity.analysis.dto;

import com.ellabook.entity.analysis.vo.ChannelDataVO;
import com.ellabook.util.BigDecimalUtil;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @Author: Ch
 * @Description:
 * @Date:Created 2018/9/13 15:42
 * @Modified By:
 */
//@Data
@Setter
@NoArgsConstructor
@AllArgsConstructor
public class UserSynopsisActiveDataDTO extends BaseUserSynopsisDataDTO {
//    /************总用户*************/
//    /**
//     * 用户总数(含游客)
//     */
//    private int totalUserNum;
//    /**
//     * 历史数据：对比用户总数
//     */
//    private int compareTotalUserNum;
    /*************活跃用户************/
    /**
     * 活跃用户数
     */
    @Getter
    private int activeUserNum;
    /**
     * 历史数据：对比活跃用户数
     */
//    @Getter
    private int compareActiveUserNum;
    /**
     * 活跃用户变化率
     */
    @Getter
    private double activeUserChangingRate;
    /**
     * 新用户（含游客）//
     */
    private int activeNewUserNum;
    /**
     * 新用户的占比:占活跃用户
     */
    @Getter
    private double activeNewUserRate;
    /**
     * 老用户占比：占活跃用户
     */
    @Getter
    private double activeOldUserRate;
    /**
     * iOS活跃用户
     */
    private int iosActiveUserNum;
    /**
     * iOS活跃占比：占活跃用户
     */
    @Getter
    private double iosActiveUserRate;
    /**
     * 安卓活跃占比：占活跃用户
     */
    @Getter
    private double androidActiveUserRate;
    /**
     * 安卓各渠道用户占比：占活跃用户
     */
    @Getter
    private List<ChannelDataVO> channelActiveDataList = new ArrayList<>();
    /**
     * 注册后只启动一次//
     */
    private double activeAppStartOnceUserNum;
    /**
     * 注册后只启动一次占比：占活跃用户
     */
    @Getter
    private double activeAppStartOnceUserRate;
    /*
     * 新增忠诚用户
     * @author chenlili
     * @date 2018/9/30 10:20
     * @param
     * @exception
     * @version 1.0
     * @return
     */
    @Getter
    int increaseLoyaltyUserNum;
    /*
     * 新增流失用户
     * @author chenlili
     * @date 2018/9/30 10:20
     * @param
     * @exception
     * @version 1.0
     * @return
     */
    @Getter
    int increaseLeaveUserNum;
    /*
     * 新增回流用户
     * @author chenlili
     * @date 2018/9/30 10:21
     * @param
     * @exception
     * @version 1.0
     * @return
     */
    @Getter
    int increaseReflowUserNum;
//    /**
//     * 新增忠诚用户：占活跃用户
//     */
//    @Getter
//    private double newLoyaltyUserRate;
//    /**
//     * 新增流失用户：占总用户
//     */
//    @Getter
//    private double newLeaveUserRate;
//    /**
//     * 新增回流用户：占活跃用户
//     */
//    @Getter
//    private double newReflowUserRate;

    public void compute() {
        if (activeUserNum <= 0) {
            return;
        }

//        （本时间段活跃用户/本时间段用户总数-上时间段活跃用户/上时间段总用户数）*100%
//        activeUserChangingRate = sub(percentScale(activeUserNum, totalUserNum), percentScale(compareActiveUserNum, compareTotalUserNum));
//        新用户（老用户）数/活跃用户数*100%
        activeNewUserRate = percent(activeNewUserNum, activeUserNum);
        activeOldUserRate = leftPercentScale(activeUserNum, activeNewUserNum);
        computeChannel(false);//已计算

//        新用户中，只启动一次用户数量，启动次数大于等于2则不算
        activeAppStartOnceUserRate = percent(activeAppStartOnceUserNum, activeUserNum);

        ////        连续每日启动至少1次的用户达到14天，数量+1，中断时数量-1，重新计算时间//去重
//        newLoyaltyUserRate = percent(increaseLoyaltyUserNum, activeUserNum);
////        当前筛选时间内，达到60天及以上未启动APP的用户，数量+1，去重
//        newLeaveUserRate = percent(increaseLeaveUserNum, activeUserNum);
////        连续60天，未启动APP，在选择时间段内启动APP，数量+1，去重
//        newReflowUserRate = percent(increaseReflowUserNum, activeUserNum);

    }

    private void computeChannel(boolean compute) {
        //        平台（渠道）活跃用户数量/活跃用户数*100%
        BigDecimal iosActiveNum = BigDecimal.ZERO;
        BigDecimal total = new BigDecimal(activeUserNum);
        for (ChannelDataVO channelDataVO : channelActiveDataList) {
            if (compute) {
                channelDataVO.compute(channelDataVO.getChannelNum(), total);
            }

            if (ifIOS(channelDataVO.getChannelName())) {
                iosActiveUserRate += channelDataVO.getChannelRate();
                iosActiveNum = BigDecimalUtil.add(iosActiveNum, channelDataVO.getChannelNum());
            }
        }
        //contain ios
        channelActiveDataList = channelActiveDataList.stream().filter(e -> toChannelFilter(e)).collect(Collectors.toList());
//        Collections.sort(channelActiveDataList, Comparator.comparing(ChannelDataVO::getChannelRate).reversed());
        androidActiveUserRate = leftPercentScale(activeUserNum, iosActiveNum.doubleValue());
    }

    public void computeForActiveUser() {
        if (activeUserNum <= 0) {
            return;
        }

        activeUserChangingRate = percent((activeUserNum - compareActiveUserNum), activeUserNum);
//        新用户（老用户）数/活跃用户数*100%
        activeNewUserRate = percent(activeNewUserNum, activeUserNum);
        activeOldUserRate = leftPercentScale(activeUserNum, activeNewUserNum);
        computeChannel(true);
        Collections.sort(channelActiveDataList, Comparator.comparing(ChannelDataVO::getChannelRate).reversed());
    }
}
