package com.ellabook.entity.analysis.dto;

import com.ellabook.entity.analysis.vo.ChannelDataVO;
import com.ellabook.util.BigDecimalUtil;
import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;

/**
 * @Author: Ch
 * @Description:
 * @Date:Created 2018/9/13 15:42
 * @Modified By:
 */
public abstract class BaseUserSynopsisDataDTO {
    protected static List<String> iosChannelNames = Arrays.asList("APPLE_STORE", "IOS");
    private final static int scale = 2;

//    protected double leftPercent(double num, double percent) {
//        if (num <= 0D) {
//            return 0D;
//        }
//        return sub(100, percent,scale);
//    }

    protected double sub(double total, double percent) {
        return sub(total, percent, scale);
    }

    private double sub(double total, double percent, int scale) {
        return BigDecimalUtil.sub(new BigDecimal(total), new BigDecimal(percent), scale).doubleValue();
    }

    private double div(double value, double divisor, int scale) {
        return BigDecimalUtil.div(value, divisor, scale);
    }

    protected double percent(double v, double divisor) {
        if (divisor == 0D) {
            return 0D;
        }
        return div(v * 100, divisor, scale);
    }

    protected double percentScale(double v, double divisor) {
        if (divisor == 0D) {
            return 0D;
        }
        return div(v * 100, divisor, 8);
    }

    protected double leftPercentScale(double divisor, double v) {
        if (divisor <= 0D) {
            return 0D;
        }
        return percent(divisor - v, divisor);
    }

    protected double percent(BigDecimal value, BigDecimal divisor) {
        if (divisor == null || value == null || divisor.doubleValue() == 0D) {
            return 0D;
        }
        return BigDecimalUtil.div(value.multiply(new BigDecimal(100)), divisor, scale).doubleValue();
    }

    protected static boolean ifIOS(String channelDataVOName) {
//        return StringUtils.equalsAnyIgnoreCase(channelDataVOName,iosChannelNames);
        return iosChannelNames.stream().anyMatch(n -> StringUtils.equalsIgnoreCase(n, channelDataVOName));
    }

    public static boolean toChannelFilter(ChannelDataVO e) {
        return !ifIOS(e.getChannelName())
                && e.getChannelRate() > 0D;
    }
}
