package com.ellabook.entity.analysis;

import java.math.BigDecimal;

public class DashboardData {


    private Integer activeUser; //当天活跃用户
    private Integer activeReadUser; //当天阅读活跃
    private Integer payUser; //当天付费用户
    private Integer registerUser; //当天新增用户

    private String registerUserRate; //新增用户比例
    private String activeUserRate; //阅读活跃比例
    private String payUserRate; //付费用户比例

    private BigDecimal incomeAmount; //收入金额
    private BigDecimal rechargeAmount; //当天充值金额
    private BigDecimal vipAmount; //当天会员总收入

    private String rechargeIncomeRate; //充值收入比例
    private String vipIncomeRate; //会员收入比例

    private Integer vipYear; // 年卡会员
    private Integer vipMonth; //月卡会员
    private Integer vipWeek; //周卡会员

    private Integer totalRegisterNum;  //注册用户总数
    private Integer totalPayUserNum; //总付费用户数
    private String totalPayUserRate; //总付费用户比例

    private Integer totalVipUser; //总会员用户数
    private BigDecimal totalRechargeAmount; //总充值金额


    private Integer appleRegisterUser;
    private Integer androidRegisterUser;
    private BigDecimal applePayAmount;
    private String applePayAmountRate;
    private BigDecimal wxpayAmount;
    private String wxpayAmountRate;
    private BigDecimal alipayAmount;
    private String alipayAmountRate;
    private Integer applePayNum;
    private String applePayNumRate;
    private Integer huaweiPayNum;//华为付费用户数
    private BigDecimal huaweiPayAmount;//华为付费金额
    private Integer androidPayNum;
    private String androidPayNumRate;

    private Integer rechargeNum;
    private String rechargeNumRate;
    private Integer subscribeNum;
    private String subscribeNumRate;
    private Integer rechargeSubscribeNum;
    private String rechargeSubscribeNumRate;


    public DashboardData() {
    }

    public DashboardData(Integer payUser, BigDecimal incomeAmount, BigDecimal rechargeAmount,
                         BigDecimal vipAmount, Integer vipYear, Integer vipMonth, Integer vipWeek, Integer totalRegisterNum,
                         Integer totalPayUserNum, Integer totalVipUser, BigDecimal totalRechargeAmount) {
        this.payUser = payUser;
        this.incomeAmount = incomeAmount;
        this.rechargeAmount = rechargeAmount;
        this.vipAmount = vipAmount;
        this.vipYear = vipYear;
        this.vipMonth = vipMonth;
        this.vipWeek = vipWeek;
        this.totalRegisterNum = totalRegisterNum;
        this.totalPayUserNum = totalPayUserNum;
        this.totalVipUser = totalVipUser;
        this.totalRechargeAmount = totalRechargeAmount;
    }

    public DashboardData(Integer payUser, BigDecimal incomeAmount, BigDecimal rechargeAmount,
                         BigDecimal vipAmount, String rechargeIncomeRate, String vipIncomeRate, Integer vipYear,
                         Integer vipMonth, Integer vipWeek, Integer totalRegisterNum,
                         Integer totalPayUserNum, String totalPayUserRate, Integer totalVipUser, BigDecimal totalRechargeAmount) {

        this.payUser = payUser;
        this.incomeAmount = incomeAmount;
        this.rechargeAmount = rechargeAmount;
        this.vipAmount = vipAmount;
        this.rechargeIncomeRate = rechargeIncomeRate;
        this.vipIncomeRate = vipIncomeRate;
        this.vipYear = vipYear;
        this.vipMonth = vipMonth;
        this.vipWeek = vipWeek;
        this.totalRegisterNum = totalRegisterNum;
        this.totalPayUserNum = totalPayUserNum;
        this.totalPayUserRate = totalPayUserRate;
        this.totalVipUser = totalVipUser;
        this.totalRechargeAmount = totalRechargeAmount;
    }

    public DashboardData(Integer activeUser, Integer activeReadUser, Integer payUser, String activeUserRate,
                         String payUserRate, BigDecimal incomeAmount, BigDecimal rechargeAmount,
                         BigDecimal vipAmount, String rechargeIncomeRate, String vipIncomeRate, Integer vipYear,
                         Integer vipMonth, Integer vipWeek, Integer totalRegisterNum,
                         Integer totalPayUserNum, String totalPayUserRate, Integer totalVipUser, BigDecimal totalRechargeAmount) {
        this.activeUser = activeUser;
        this.activeReadUser = activeReadUser;
        this.payUser = payUser;
        this.activeUserRate = activeUserRate;
        this.payUserRate = payUserRate;
        this.incomeAmount = incomeAmount;
        this.rechargeAmount = rechargeAmount;
        this.vipAmount = vipAmount;
        this.rechargeIncomeRate = rechargeIncomeRate;
        this.vipIncomeRate = vipIncomeRate;
        this.vipYear = vipYear;
        this.vipMonth = vipMonth;
        this.vipWeek = vipWeek;
        this.totalRegisterNum = totalRegisterNum;
        this.totalPayUserNum = totalPayUserNum;
        this.totalPayUserRate = totalPayUserRate;
        this.totalVipUser = totalVipUser;
        this.totalRechargeAmount = totalRechargeAmount;
    }

    public DashboardData(Integer activeUser, Integer activeReadUser, Integer payUser, Integer registerUser, String activeUserRate, String payUserRate, Integer totalRegisterNum, Integer totalPayUserNum, String totalPayUserRate, Integer totalVipUser, BigDecimal totalRechargeAmount) {
        this.activeUser = activeUser;
        this.activeReadUser = activeReadUser;
        this.payUser = payUser;
        this.registerUser = registerUser;
        this.activeUserRate = activeUserRate;
        this.payUserRate = payUserRate;
        this.totalRegisterNum = totalRegisterNum;
        this.totalPayUserNum = totalPayUserNum;
        this.totalPayUserRate = totalPayUserRate;
        this.totalVipUser = totalVipUser;
        this.totalRechargeAmount = totalRechargeAmount;
    }

    public Integer getHuaweiPayNum() {
        return huaweiPayNum;
    }

    public void setHuaweiPayNum(Integer huaweiPayNum) {
        this.huaweiPayNum = huaweiPayNum;
    }

    public BigDecimal getHuaweiPayAmount() {
        return huaweiPayAmount;
    }

    public void setHuaweiPayAmount(BigDecimal huaweiPayAmount) {
        this.huaweiPayAmount = huaweiPayAmount;
    }

    public String getRegisterUserRate() {
        return registerUserRate;
    }

    public void setRegisterUserRate(String registerUserRate) {
        this.registerUserRate = registerUserRate;
    }

    public Integer getRegisterUser() {
        return registerUser;
    }

    public void setRegisterUser(Integer registerUser) {
        this.registerUser = registerUser;
    }

    public Integer getActiveUser() {
        return activeUser;
    }

    public void setActiveUser(Integer activeUser) {
        this.activeUser = activeUser;
    }

    public Integer getActiveReadUser() {
        return activeReadUser;
    }

    public void setActiveReadUser(Integer activeReadUser) {
        this.activeReadUser = activeReadUser;
    }

    public Integer getPayUser() {
        return payUser;
    }

    public void setPayUser(Integer payUser) {
        this.payUser = payUser;
    }

    public String getActiveUserRate() {
        return activeUserRate;
    }

    public void setActiveUserRate(String activeUserRate) {
        this.activeUserRate = activeUserRate;
    }

    public String getPayUserRate() {
        return payUserRate;
    }

    public void setPayUserRate(String payUserRate) {
        this.payUserRate = payUserRate;
    }

    public BigDecimal getIncomeAmount() {
        return incomeAmount;
    }

    public void setIncomeAmount(BigDecimal incomeAmount) {
        this.incomeAmount = incomeAmount;
    }

    public BigDecimal getRechargeAmount() {
        return rechargeAmount;
    }

    public void setRechargeAmount(BigDecimal rechargeAmount) {
        this.rechargeAmount = rechargeAmount;
    }

    public BigDecimal getVipAmount() {
        return vipAmount;
    }

    public void setVipAmount(BigDecimal vipAmount) {
        this.vipAmount = vipAmount;
    }

    public String getRechargeIncomeRate() {
        return rechargeIncomeRate;
    }

    public void setRechargeIncomeRate(String rechargeIncomeRate) {
        this.rechargeIncomeRate = rechargeIncomeRate;
    }

    public String getVipIncomeRate() {
        return vipIncomeRate;
    }

    public void setVipIncomeRate(String vipIncomeRate) {
        this.vipIncomeRate = vipIncomeRate;
    }

    public Integer getVipYear() {
        return vipYear;
    }

    public void setVipYear(Integer vipYear) {
        this.vipYear = vipYear;
    }

    public Integer getVipMonth() {
        return vipMonth;
    }

    public void setVipMonth(Integer vipMonth) {
        this.vipMonth = vipMonth;
    }

    public Integer getVipWeek() {
        return vipWeek;
    }

    public void setVipWeek(Integer vipWeek) {
        this.vipWeek = vipWeek;
    }

    public Integer getTotalRegisterNum() {
        return totalRegisterNum;
    }

    public void setTotalRegisterNum(Integer totalRegisterNum) {
        this.totalRegisterNum = totalRegisterNum;
    }

    public Integer getTotalPayUserNum() {
        return totalPayUserNum;
    }

    public void setTotalPayUserNum(Integer totalPayUserNum) {
        this.totalPayUserNum = totalPayUserNum;
    }

    public String getTotalPayUserRate() {
        return totalPayUserRate;
    }

    public void setTotalPayUserRate(String totalPayUserRate) {
        this.totalPayUserRate = totalPayUserRate;
    }

    public Integer getTotalVipUser() {
        return totalVipUser;
    }

    public void setTotalVipUser(Integer totalVipUser) {
        this.totalVipUser = totalVipUser;
    }

    public BigDecimal getTotalRechargeAmount() {
        return totalRechargeAmount;
    }

    public void setTotalRechargeAmount(BigDecimal totalRechargeAmount) {
        this.totalRechargeAmount = totalRechargeAmount;
    }

    public Integer getAppleRegisterUser() {
        return appleRegisterUser;
    }

    public void setAppleRegisterUser(Integer appleRegisterUser) {
        this.appleRegisterUser = appleRegisterUser;
    }

    public Integer getAndroidRegisterUser() {
        return androidRegisterUser;
    }

    public void setAndroidRegisterUser(Integer androidRegisterUser) {
        this.androidRegisterUser = androidRegisterUser;
    }

    public BigDecimal getApplePayAmount() {
        return applePayAmount;
    }

    public void setApplePayAmount(BigDecimal applePayAmount) {
        this.applePayAmount = applePayAmount;
    }

    public String getApplePayAmountRate() {
        return applePayAmountRate;
    }

    public void setApplePayAmountRate(String applePayAmountRate) {
        this.applePayAmountRate = applePayAmountRate;
    }

    public BigDecimal getWxpayAmount() {
        return wxpayAmount;
    }

    public void setWxpayAmount(BigDecimal wxpayAmount) {
        this.wxpayAmount = wxpayAmount;
    }

    public String getWxpayAmountRate() {
        return wxpayAmountRate;
    }

    public void setWxpayAmountRate(String wxpayAmountRate) {
        this.wxpayAmountRate = wxpayAmountRate;
    }

    public BigDecimal getAlipayAmount() {
        return alipayAmount;
    }

    public void setAlipayAmount(BigDecimal alipayAmount) {
        this.alipayAmount = alipayAmount;
    }

    public String getAlipayAmountRate() {
        return alipayAmountRate;
    }

    public void setAlipayAmountRate(String alipayAmountRate) {
        this.alipayAmountRate = alipayAmountRate;
    }

    public Integer getApplePayNum() {
        return applePayNum;
    }

    public void setApplePayNum(Integer applePayNum) {
        this.applePayNum = applePayNum;
    }

    public String getApplePayNumRate() {
        return applePayNumRate;
    }

    public void setApplePayNumRate(String applePayNumRate) {
        this.applePayNumRate = applePayNumRate;
    }

    public Integer getAndroidPayNum() {
        return androidPayNum;
    }

    public void setAndroidPayNum(Integer androidPayNum) {
        this.androidPayNum = androidPayNum;
    }

    public String getAndroidPayNumRate() {
        return androidPayNumRate;
    }

    public void setAndroidPayNumRate(String androidPayNumRate) {
        this.androidPayNumRate = androidPayNumRate;
    }

    public Integer getRechargeNum() {
        return rechargeNum;
    }

    public void setRechargeNum(Integer rechargeNum) {
        this.rechargeNum = rechargeNum;
    }

    public String getRechargeNumRate() {
        return rechargeNumRate;
    }

    public void setRechargeNumRate(String rechargeNumRate) {
        this.rechargeNumRate = rechargeNumRate;
    }

    public Integer getSubscribeNum() {
        return subscribeNum;
    }

    public void setSubscribeNum(Integer subscribeNum) {
        this.subscribeNum = subscribeNum;
    }

    public String getSubscribeNumRate() {
        return subscribeNumRate;
    }

    public void setSubscribeNumRate(String subscribeNumRate) {
        this.subscribeNumRate = subscribeNumRate;
    }

    public Integer getRechargeSubscribeNum() {
        return rechargeSubscribeNum;
    }

    public void setRechargeSubscribeNum(Integer rechargeSubscribeNum) {
        this.rechargeSubscribeNum = rechargeSubscribeNum;
    }

    public String getRechargeSubscribeNumRate() {
        return rechargeSubscribeNumRate;
    }

    public void setRechargeSubscribeNumRate(String rechargeSubscribeNumRate) {
        this.rechargeSubscribeNumRate = rechargeSubscribeNumRate;
    }
}