package com.ellabook.entity;


import com.alibaba.fastjson.annotation.JSONField;

import java.io.Serializable;

/**
 * 返回请求参数
 * Date          Author       Version       Description
 * ----------------------------------------------------------
 * 2017-8-21      yanlei            1.0           Create
 */
public class ResponseParams<T> implements Serializable {
    private String code = "0x00000000"; // 错误码

    private String status = "0"; //状态（0或1）

    private String message = "";//描述信息（成功或失败原因）

    private String remark = "";//接口名

    private T data;

    public ResponseParams() {
    }

    public ResponseParams success() {
        this.status = "1";
        this.message = "【调用成功】";
        this.code = "0x00000000";
        return this;
    }

    public ResponseParams error() {
        this.status = "0";
        this.message = "【调用失败】";
        this.code = "500";
        return this;
    }

    public ResponseParams error(String code, String message) {
        this.status = "0";
        this.message = message;
        this.code = code;
        return this;
    }

    public ResponseParams(String remark) {
        this.remark = remark;
    }

    public ResponseParams(String remark, T data) {
        this.remark = remark;
        this.data = data;
    }

    public ResponseParams(String code, String status, String message, String remark, T data) {
        this.code = code;
        this.status = status;
        this.message = message;
        this.remark = remark;
        this.data = data;
    }

    public ResponseParams(String code, String status, String message, String remark) {
        this.code = code;
        this.status = status;
        this.message = message;
        this.remark = remark;
    }

    public ResponseParams(String status, String message, T data) {
        this.status = status;
        this.message = message;
        this.data = data;
    }

    public ResponseParams fill(String status, String message, T data) {
//        this.setData(data);
//        this.fill(status, message);
        this.data = data;
        this.status = status;
        this.message = message;
        return this;
    }

    public ResponseParams fill(String code, String message) {
        this.setCode(code);
        this.setMessage(message);
        return this;
    }

    public ResponseParams fill(String code, String message, String status) {
        this.fill(code, message);
        this.setStatus(status);
        return this;
    }

    public ResponseParams fill(String code, String message, String status, T data) {
        this.fill(code, message);
        this.setStatus(status);
        this.setData(data);
        return this;
    }

    public void setStatusAndMessage(String status, String message) {
        this.status = status;
        this.message = message;
    }

    public void setCodeAndMessage(String code, String message) {
        this.code = code;
        this.message = message;
    }


    public void setStatusCodeAndMessage(String status, String code, String message) {
        this.status = status;
        this.code = code;
        this.message = message;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public T getData() {
        return data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public ResponseParams fillSuccess(String message) {
        this.setMessage(message);
        this.setStatus("1");
        this.setCode("00000000");
        return this;
    }

    public ResponseParams<T> fillSuccess(T data) {
        this.status = "1";
        this.message = "[调用成功]";
        this.code = "200";
        this.data = data;
        return this;
    }

    //海外数据同步所需字段 方便aop处理除content以外的参数
    @JSONField(serialize = false)
    public String keyWord;

    public String getKeyWord() {
        return keyWord;
    }

    public void setKeyWord(String keyWord) {
        this.keyWord = keyWord;
    }
}
