package com.ellabook.constraint.inf.impl;


import com.ellabook.constraint.annotation.DefaultLength;
import com.ellabook.constraint.inf.SetDefault;

import javax.validation.ConstraintViolation;

/**
 * Set default {@link String} value for {@Code field} annotated by {@link DefaultLength}
 */
public class SetValidLengthDefault implements SetDefault<DefaultLength, String> {

    @Override
    public <B> void setDefault(ConstraintViolation<B> tConstraintViolation, DefaultLength annotation) throws Exception {
        String value = annotation.value();
        invokeSetFieldValue(tConstraintViolation, value);
    }

    @Override
    public Class<DefaultLength> getAnnotation() {
        return DefaultLength.class;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
    }


}
