package com.ellabook.aspect;

import java.lang.annotation.*;

/**
 * 防止并发操作
 *
 * @author LiBin
 * @email libin@ellabook.cn
 * @create 2018-01-11 14:57
 **/
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.METHOD})
@Documented
public @interface AvoidConcurrent {
    /**
     * 关键字 可以唯一确认一个操作的字段<br/>
     * 比如修改操作的逻辑主键字段(primaryKey="uid")
     */
    String[] primaryKey() default {""};

    Class<? extends PrimaryKeyHelper> keyHelperClz() default PrimaryKeyHelper.class;

}
