package com.constants;

import java.util.HashMap;
import java.util.Map;

import static com.constants.LanguageConstant.*;

/**
 * @author ：xixiaoyi
 * @date ：Created by 2019/11/5
 * @modified By：
 */
public class LanguageMapConstant {

    /**
     * 个人中心 咿啦币/红包返回数据语言
     *
     * @return
     */
    public static Map<String, String> getBalanceMap() {
        Map<String, String> map = new HashMap(4);
        map.put(ZH_CN, "个");
        map.put(ZH_FT, "個");
        map.put(EN_US, "");
        map.put(KO_KR, "");
        map.put(JA_JP, "");
        return map;
    }

    /**
     * 个人中心 积分返回数据语言
     *
     * @return
     */
    public static Map<String, String> getPointsMap() {
        Map<String, String> map = new HashMap(4);
        map.put(ZH_CN, "积分");
        map.put(ZH_FT, "積分");
        map.put(EN_US, "");
        map.put(KO_KR, "");
        map.put(JA_JP, "");
        return map;
    }

    /**
     * 个人中心 会员返回数据语言
     *
     * @return
     */
    public static Map<String, String> getVIPMap() {
        Map<String, String> map = new HashMap(4);
        map.put(ZH_CN, "免费看绘本");
        map.put(ZH_FT, "免費看繪本");
        map.put(EN_US, "book for free");
        map.put(KO_KR, "book for free");
        map.put(JA_JP, "book for free");
        return map;
    }

    /**
     * 个人中心 会员今日到期
     *
     * @return
     */
    public static Map<String, String> getVIPExpiredTodayMap() {
        Map<String, String> map = new HashMap(4);
        map.put(ZH_CN, "今日到期");
        map.put(ZH_FT, "今日到期");
        map.put(EN_US, "Expired today");
        map.put(KO_KR, "Expired today");
        map.put(JA_JP, "Expired today");
        return map;
    }

    /**
     * 个人中心某天后到期
     *
     * @return
     */
    public static Map<String, String> getVIPExpiredAfterDaysMap() {
        Map<String, String> map = new HashMap(4);
        map.put(ZH_CN, "{day}天后到期");
        map.put(ZH_FT, "{day}天后到期");
        map.put(EN_US, "Expires after {day} days");
        map.put(KO_KR, "Expires after {day} days");
        map.put(JA_JP, "Expires after {day} days");
        return map;
    }

    /**
     * 打卡返现
     */
    private static Map<String, Map<String, String>> clockMap = new HashMap(16);

    static {
        Map<String, String> clocking = new HashMap<>();
        Map<String, String> clockEnded = new HashMap<>();
        Map<String, String> clockStart = new HashMap<>();
        clockStart.put(ZH_CN, "活动报名中");
        clockStart.put(ZH_FT, "活動報名中");
        clockStart.put(EN_US, "Signing up");
        clockStart.put(KO_KR, "Signing up");
        clockStart.put(JA_JP, "Signing up");

        clockEnded.put(ZH_CN, "");
        clockEnded.put(ZH_FT, "");
        clockEnded.put(EN_US, "");
        clockEnded.put(KO_KR, "");
        clockEnded.put(JA_JP, "");

        clocking.put(ZH_CN, "累计打卡{day}天");
        clocking.put(ZH_FT, "累計打卡{day}天");
        clocking.put(EN_US, "Accumulated punch {day} days");
        clocking.put(KO_KR, "Accumulated punch {day} days");
        clocking.put(JA_JP, "Accumulated punch {day} days");

        clockMap.put("clocking", clocking);
        clockMap.put("clockEnded", clockEnded);
        clockMap.put("clockStart", clockStart);
    }

    /**
     * 个人中心打卡返现
     *
     * @return
     */
    public static Map<String, String> getClock(String type) {
        Map<String, String> map;
        if (type.equals("clocking")) {
            map = clockMap.get("clocking");
        } else if (type.equals("clockEnded")) {
            map = clockMap.get("clockEnded");
        } else {
            map = clockMap.get("clockStart");
        }
        return map;
    }
}
