package com.bbk.vo;

import lombok.Data;

import java.util.Map;

/**
 * 签名对象
 *
 * @author baigang
 * @date 2019-05-16 08:13
 * @since 1.0.0
 */
@Data
public class SignVo {
    /**
     * 签名密钥，不能为空
     */
    public String secret;
    /**
     * 请求方式，不能为空
     */
    public String method;
    /**
     * 请求路径，不能为空
     */
    public String requestPath;
    /**
     * 当请求参数以json形式传入body中传递时，body中的json字串经过aes堆成加密的字串（AES加密工具类已提供），密钥同签名密钥
     * 若Content-Type非application/json时，该值为空
     */
    public String bodyEncryptString;
    /**
     * 请求参数
     */
    public Map<String, String> bodys;
    /**
     * 查询参数，若无则传空
     */
    public Map<String, String> querys;
    /**
     * 请求头，不能为空
     */
    public Map<String, String> headers;

}
