package com.bbk.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

/**
 * @author baigang
 * @date 2019-03-23 12:00
 * @since 1.0.0
 */
public class Md5Util {

    private static Logger log = LoggerFactory.getLogger(Md5Util.class);

    private static final char[] HEX_DIGITS = {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D',
            'E', 'F'};

    private static String toHexString(byte[] b) {
        StringBuilder sb = new StringBuilder(b.length * 2);
        for (int i = 0; i < b.length; i++) {
            sb.append(HEX_DIGITS[(b[i] & 0xf0) >>> 4]);
            sb.append(HEX_DIGITS[b[i] & 0x0f]);
        }
        return sb.toString();
    }

    public static String Bit32(String SourceString) {
        MessageDigest digest = null;
        try {
            digest = MessageDigest.getInstance("MD5");
            digest.update(SourceString.getBytes("UTF-8"));
            byte[] messageDigest = digest.digest();
            return toHexString(messageDigest);
        } catch (NoSuchAlgorithmException | UnsupportedEncodingException e) {
            log.error(String.format("不支持的算法或编码格式: %s", e.getMessage()));
            return "";
        }
    }

    public static String Bit16(String SourceString) {
        return Bit32(SourceString).substring(8, 24);
    }
}
