package com.bbk.util;

import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

/**
 * 通用工具类
 *
 * @author baigang
 * @date 2019-04-23 20:12
 * @since 1.0.0
 */
public class CommonUtil {
    private static final Logger log = LoggerFactory.getLogger(CommonUtil.class);

    public static Map<String, String> getUrlMap(String url) {
        Map<String, String> map = new HashMap<>();
        URL urls = null;
        try {
            urls = new URL(url);
            String param = urls.getQuery();
            if (StringUtils.isNotBlank(param)) {
                String[] arr = param.split("&");
                for (String s : arr) {
                    String key = s.split("=")[0];
                    String value = s.split("=")[1];
                    map.put(key, value);
                }
            }
        } catch (MalformedURLException e) {
            log.warn("getUrlMap", "MalformedURLException e={}" + e);
        }
        return map;
    }

    /**
     * 将Map拼写到URL中
     *
     * @param params
     * @return
     */
    public static String getMapToUrl(Map<String, String> params) {
        StringBuilder urlParams = new StringBuilder("?");
        params.forEach((k, v) -> {
            urlParams.append(k).append("=").append(v).append("&");
        });
        String urlParamsStr = urlParams.toString();
        return urlParamsStr.substring(0, urlParamsStr.length() - 1);
    }


    public static String responseConvert(Map<String, String> resultMap) {
        String result = "";
        if (resultMap != null && !resultMap.isEmpty()) {
            String code = resultMap.get("code"); //http请求状态码
            if (StringUtils.isNotBlank(code) && code.equals("200")) {
                String body = resultMap.get("body"); //http请求返回内容'
                return body;
//                if (StringUtils.isNotBlank(body)) {
                    /*ResponseDTO responseDTO = JSONObject.parseObject(body, ResponseDTO.class);
                    if (responseDTO != null) {
                        if (responseDTO.getStateCode().equals("0")) {
                            return responseDTO.getData();
                        } else {
                            return responseDTO.getStateCode();
                        }
                    }*/
//                }
            } else {
                log.info(JSONObject.toJSONString(resultMap));
            }
        }
        return result;
    }
}
