package com.bbk.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

import javax.crypto.*;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;

/**
 * @version V1.0
 * @desc AES 加密工具类
 */
public class AesUtil {
    private static final Logger LOGGER = LoggerFactory
            .getLogger(AesUtil.class);
    /**
     * 加密算法
     */
    public static final String CBC_CIPHER_ALGORITHM = "AES/CBC/PKCS5Padding";
    /**
     * 编码格式
     */
    private static final String ENCODING = "UTF-8";

    private static final String KEY_ALGORITHM = "AES";


    public static String encrypt(String content, String encodeRules) {
        try {
            SecretKey key = (SecretKey) initKeyForAES(encodeRules);
            //1.根据指定算法AES自成密码器
            Cipher cipher = Cipher.getInstance(CBC_CIPHER_ALGORITHM);
            //2.初始化密码器，第一个参数为加密(Encrypt_mode)或者解密解密(Decrypt_mode)操作，第二个参数为使用的KEY
            cipher.init(Cipher.ENCRYPT_MODE, key, new IvParameterSpec(encodeRules.getBytes(ENCODING)));
            //3.获取加密内容的字节数组(这里要设置为utf-8)不然内容中如果有中文和英文混合中文就会解密为乱码
            byte[] contentEncodeByte = content.getBytes(ENCODING);
            //4.根据密码器的初始化方式--加密：将数据加密
            byte[] contentAesByte = cipher.doFinal(contentEncodeByte);
            //5.将加密后的数据转换为字符串
            //这里用Base64Encoder中会找不到包
            //解决办法：
            //在项目的Build path中先移除JRE System Library，再添加库JRE System Library，重新编译后就一切正常了。
            String contentAes = new BASE64Encoder().encode(contentAesByte);
            //6.将字符串返回
            return contentAes;
        } catch (NoSuchAlgorithmException e) {
            LOGGER.error(String.format("AES.encrypt failed.content:%s", content), e);
        } catch (NoSuchPaddingException e) {
            LOGGER.error(String.format("AES.encrypt failed.content:%s", content), e);
        } catch (InvalidKeyException e) {
            LOGGER.error(String.format("AES.encrypt failed.content:%s", content), e);
        } catch (IllegalBlockSizeException e) {
            LOGGER.error(String.format("AES.encrypt failed.content:%s", content), e);
        } catch (BadPaddingException e) {
            LOGGER.error(String.format("AES.encrypt failed.content:%s", content), e);
        } catch (UnsupportedEncodingException e) {
            LOGGER.error(String.format("AES.encrypt failed.content:%s", content), e);
        } catch (InvalidAlgorithmParameterException e) {
            LOGGER.error(String.format("AES.encrypt failed.content:%s", content), e);
        }

        //如果有错就返加nulll
        return null;
    }

    /**
     * 解密
     *
     * @param content
     * @param encodeRules
     * @return
     */
    public static String decrypt(String content, String encodeRules) {
        try {
            //1.根据字节数组生成AES密钥
            SecretKey key = (SecretKey) initKeyForAES(encodeRules);
            //2.根据指定算法AES自成密码器
            Cipher cipher = Cipher.getInstance(CBC_CIPHER_ALGORITHM);
            //3.初始化密码器，第一个参数为加密(Encrypt_mode)或者解密(Decrypt_mode)操作，第二个参数为使用的KEY
            cipher.init(Cipher.DECRYPT_MODE, key, new IvParameterSpec(encodeRules.getBytes(ENCODING)));
            //4.将加密并编码后的内容解码成字节数组
            byte[] contentAes = new BASE64Decoder().decodeBuffer(content);
            //5.解密
            byte[] contentEncodeByte = cipher.doFinal(contentAes);
            String contentSrc = new String(contentEncodeByte, ENCODING);
            return contentSrc;
        } catch (NoSuchAlgorithmException e) {
            LOGGER.error(String.format("AES.encrypt failed.content:%s", content), e);
        } catch (NoSuchPaddingException e) {
            LOGGER.error(String.format("AES.encrypt failed.content:%s", content), e);
        } catch (InvalidKeyException e) {
            LOGGER.error(String.format("AES.encrypt failed.content:%s", content), e);
        } catch (IOException e) {
            LOGGER.error(String.format("AES.encrypt failed.content:%s", content), e);
        } catch (IllegalBlockSizeException e) {
            LOGGER.error(String.format("AES.encrypt failed.content:%s", content), e);
        } catch (BadPaddingException e) {
            LOGGER.error(String.format("AES.encrypt failed.content:%s", content), e);
        } catch (InvalidAlgorithmParameterException e) {
            LOGGER.error(String.format("AES.encrypt failed.content:%s", content), e);
        }

        //如果有错就返加nulll
        return null;
    }

    private static Key initKeyForAES(String key) {
        if (null == key || key.length() == 0) {
            throw new NullPointerException("key not is null");
        }
        SecretKey secretKey = null;
        try {
            secretKey = new SecretKeySpec(key.getBytes(ENCODING), KEY_ALGORITHM);
        } catch (UnsupportedEncodingException e) {
            LOGGER.error(String.format("AES.initKeyForAES failed.key:%s", key), e);
        }
        return secretKey;
    }
}