/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.bbk.sign.constant;

/**
 * 系统HTTP头常量
 */
public class SystemHeader {
    /**
     * 所有参与签名的Header
     **/
    public static final String X_CA_SIGNATURE_HEADERS = "X-Ca-Signature-Headers";
    /**
     * Debug开关 选填 不设置默认关闭，设置为debug则可以不校验签名（stage为release时忽略debug）直接请求
     */
    public static final String X_CA_MODEL = "s-mode";
    /**
     * 公共头版本 为1
     */
    public static final String X_CA_VERSION = "s-version";
    /**
     * 特性分支 选填 支持test和 release 默认为release
     */
    public static final String X_CA_STAGE = "s-stage";
    /**
     * 请求时间戳
     */
    public static final String X_CA_TIMESTAMP = "s-timestamp";
    /**
     * 请求放重放Nonce,15分钟内保持唯一,建议使用UUID
     */
    public static final String X_CA_NONCE = "s-nonce";
    /**
     * body中的内容摘要，只有当body的提交方式非form的时候才有此内容
     */
    public static final String X_CA_CONTENT_MD5 = "s-content-md5";
    /**
     * APP KEY
     */
    public static final String X_CA_KEY = "s-app-key";
    /**
     * 签名Header
     */
    public static final String X_CA_SIGNATURE = "s-sign";
}
