package com.analysis.entity.ellahome.dto;

import lombok.Data;

import java.math.BigDecimal;

@Data
public class DashboardDataDTO {
    private Integer todayKindergartenNum; //当天新增幼儿园数量
    private Integer yesterdayKindergartenNum; //昨天新增幼儿园数量
    private Integer totalKindergartenNum; //总幼儿园数量
    private String todayKindergartenIncreaseRate; //当天幼儿园增长率

    private Integer todayClassNum; //当天新增班级数量
    private Integer yesterdayClassNum; //昨天新增班级数量
    private Integer totalClassNum; //总班级数量
    private String todayClassIncreaseRate; //当天班级增长率


    private Integer todayTeacherNum; //当天新增老师数量
    private Integer yesterdayTeacherNum; //昨天新增老师数量
    private Integer totalTeacherNum; //总老师数量
    private String todayTeacherIncreaseRate; //当天老师增长率

    private Integer todayParentsNum; //当天新增家长数量
    private Integer yesterdayParentsNum; //昨天新增家长数量
    private Integer totalParentsNum; //总家长数量
    private String todayParentsIncreaseRate; //当天家长增长率

    private Integer todayPayUserNum; //当天付费用户数
    private String todayPayUserIncreaseRate; //当天付费用户增长率
    private Integer yesterdayPayUserNum; //昨天付费用户数
    private Integer todayApplePayUserNum; //当天苹果付费用户数
    private String todayApplePayUserRate; //当天苹果付费用户比例
    private Integer todayAndroidPayUserNum; //当天安卓付费用户数
    private String todayAndroidPayUserRate; //当天安卓付费用户比例
    private Integer totalPayUserNum; //累计总付费用户数
    private Integer totalApplePayUserNum; //苹果总付费用户数
    private String totalApplePayUserRate; //苹果总付费用户比例
    private Integer totalAndroidPayUserNum; //安卓总付费用户数
    private String totalAndroidPayUserRate; //安卓总付费用户比例

    private BigDecimal todayPayAmount; //当天付费金额
    private String todayPayAmountIncreaseRate; //当天付费金额增长率
    private BigDecimal yesterdayPayAmount; //昨天付费金额
    private BigDecimal todayApplePayAmount; //当天苹果付费金额
    private String todayApplePayAmountRate; //当天苹果付费金额比例
    private BigDecimal todayAndroidPayAmount; //当天安卓付费金额
    private String todayAndroidPayAmountRate; //天安卓付费金额比例
    private BigDecimal totalPayAmount; //累计总付费金额
    private BigDecimal totalApplePayAmount; //苹果总付费金额
    private String totalApplePayAmountRate; //苹果总付费金额比例
    private BigDecimal totalAndroidPayAmount; //安卓总付费金额
    private String totalAndroidPayAmountRate; //安卓总付费金额比例

    private Integer todayActiveUser; //当天活跃用户数
    private String todayActiveUserIncreaseRate; //当天活跃用户增长率
    private Integer todayAppleActiveUser; //当天IOS活跃用户
    private String todayAppleActiveUserRate; //当天IOS活跃用户比例
    private Integer todayAndroidActiveUser; //当天安卓活跃用户
    private String todayAndroidActiveUserRate; //当天安卓活跃用户比例

    private Integer yesterdayActiveUser;//昨天活跃用户数
    private Integer yesterdayAppleActiveUser; //昨天IOS活跃用户
    private String yesterdayAppleActiveUserRate; //昨天IOS活跃用户比例
    private Integer yesterdayAndroidActiveUser; //昨天安卓活跃用户
    private String yesterdayAndroidActiveUserRate; //昨天安卓活跃用户比例

    public DashboardDataDTO() {
    }

    public DashboardDataDTO(Integer todayAppleActiveUser, Integer todayAndroidActiveUser, Integer yesterdayAppleActiveUser, Integer yesterdayAndroidActiveUser) {
        this.todayAppleActiveUser = todayAppleActiveUser;
        this.todayAndroidActiveUser = todayAndroidActiveUser;
        this.yesterdayAppleActiveUser = yesterdayAppleActiveUser;
        this.yesterdayAndroidActiveUser = yesterdayAndroidActiveUser;
    }

    public DashboardDataDTO(Integer yesterdayAppleActiveUser, Integer yesterdayAndroidActiveUser, Integer yesterdayActiveUser) {
        this.yesterdayAppleActiveUser = yesterdayAppleActiveUser;
        this.yesterdayAndroidActiveUser = yesterdayAndroidActiveUser;
        this.yesterdayActiveUser = yesterdayActiveUser;
    }

    public DashboardDataDTO(Integer todayAppleActiveUser, Integer todayAndroidActiveUser) {
        this.todayAppleActiveUser = todayAppleActiveUser;
        this.todayAndroidActiveUser = todayAndroidActiveUser;
    }

   /* public DashboardDataDTO(Integer todayAppleActiveUser, Integer todayAndroidActiveUser) {
        this.todayAppleActiveUser = todayAppleActiveUser;
        this.todayAndroidActiveUser = todayAndroidActiveUser;
    }*/

    public DashboardDataDTO(Integer todayActiveUser, String todayActiveUserIncreaseRate, Integer todayAppleActiveUser,
                            String todayAppleActiveUserRate, Integer todayAndroidActiveUser, String todayAndroidActiveUserRate,
                            Integer yesterdayActiveUser, Integer yesterdayAppleActiveUser, String yesterdayAppleActiveUserRate,
                            Integer yesterdayAndroidActiveUser, String yesterdayAndroidActiveUserRate) {
        this.todayActiveUser = todayActiveUser;
        this.todayActiveUserIncreaseRate = todayActiveUserIncreaseRate;
        this.todayAppleActiveUser = todayAppleActiveUser;
        this.todayAppleActiveUserRate = todayAppleActiveUserRate;
        this.todayAndroidActiveUser = todayAndroidActiveUser;
        this.todayAndroidActiveUserRate = todayAndroidActiveUserRate;
        this.yesterdayActiveUser = yesterdayActiveUser;
        this.yesterdayAppleActiveUser = yesterdayAppleActiveUser;
        this.yesterdayAppleActiveUserRate = yesterdayAppleActiveUserRate;
        this.yesterdayAndroidActiveUser = yesterdayAndroidActiveUser;
        this.yesterdayAndroidActiveUserRate = yesterdayAndroidActiveUserRate;
    }
}