/*
 * Decompiled with CFR 0.152.
 */
package ella.composition.server.service.impl;

import com.ella.entity.composition.dto.BookPageTitleRefDto;
import com.ella.entity.composition.dto.EnumDto;
import com.ella.entity.composition.dto.TitleDto;
import com.ella.entity.composition.vo.BookPageTitleRefVo;
import com.ella.entity.composition.vo.BookTitleRefVo;
import com.ella.entity.composition.vo.ParentFormatPageRefVo;
import com.ella.entity.composition.vo.TitleAnswerVo;
import com.ella.entity.composition.vo.TitleOptionVo;
import com.ella.entity.composition.vo.TitleVo;
import com.ella.response.ResponseParams;
import com.ella.util.CoreUtil;
import ella.composition.server.mapper.BookPageTitleRefMapper;
import ella.composition.server.mapper.TitleAnswerMapper;
import ella.composition.server.mapper.TitleMapper;
import ella.composition.server.mapper.TitleOptionMapper;
import ella.composition.server.service.EnumService;
import ella.composition.server.service.TitleService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TitleServiceImpl
implements TitleService {
    @Resource
    TitleMapper titleMapper;
    @Resource
    TitleOptionMapper titleOptionMapper;
    @Resource
    TitleAnswerMapper titleAnswerMapper;
    @Resource
    BookPageTitleRefMapper bookPageTitleRefMapper;
    @Resource
    EnumService enumService;

    @Transactional(rollbackFor={Exception.class})
    public ResponseParams addTitle(TitleVo titleVo, ResponseParams response) {
        String titleCode = CoreUtil.createCommonsCore((String)"T", (int)10);
        titleVo.setTitleCode(titleCode);
        int result = this.titleMapper.insertTitle(titleVo);
        boolean optionResult = this.titleOptionConvert(titleCode, titleVo.getTitleType(), titleVo.getOptionList(), response);
        this.titleAnswerConvert(titleCode, titleVo.getTitleAnswer());
        if (!optionResult) {
            return response;
        }
        this.bookPageTitleRefConvert(titleVo.getBookPage(), titleCode);
        List secondTitleList = titleVo.getSecondTitleList();
        this.subTitleConvert(secondTitleList, titleVo.getFormatSetPageCode(), titleVo.getBaseBookCode(), titleCode, response);
        if (result > 0) {
            HashMap<String, String> resultMap = new HashMap<String, String>(1);
            resultMap.put("titleCode", titleCode);
            response.fillSuccess(resultMap);
        }
        return response;
    }

    @Transactional(rollbackFor={Exception.class})
    public ResponseParams updateTitle(TitleVo titleVo, ResponseParams response) {
        if (StringUtils.isBlank((CharSequence)titleVo.getTitleCode())) {
            response.fillError("\u9898\u76ee\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a", "3100010001");
            return response;
        }
        this.titleMapper.updateTitle(titleVo);
        boolean optionResult = this.titleOptionConvert(titleVo.getTitleCode(), titleVo.getTitleType(), titleVo.getOptionList(), response);
        if (!optionResult) {
            return response;
        }
        this.titleAnswerConvert(titleVo.getTitleCode(), titleVo.getTitleAnswer());
        int result = this.titleMapper.insertTitle(titleVo);
        this.bookPageTitleRefConvert(titleVo.getBookPage(), titleVo.getTitleCode());
        return response.fillSuccess((Object)(result > 0 ? 1 : 0));
    }

    public void subTitleConvert(List<TitleVo> titleList, String formatSetPageCode, String baseBookCode, String titleCode, ResponseParams response) {
        if (CollectionUtils.isNotEmpty(titleList)) {
            for (TitleVo subTitleVo : titleList) {
                ParentFormatPageRefVo parentFormatPageRef;
                BookTitleRefVo bookTitleRefVo;
                String subTitleCode = CoreUtil.createCommonsCore((String)"T", (int)10);
                subTitleVo.setTitleParentCode(titleCode);
                this.titleMapper.insertTitle(subTitleVo);
                this.bookPageTitleRefConvert(subTitleVo.getBookPage(), titleCode);
                this.titleOptionConvert(titleCode, subTitleVo.getTitleType(), subTitleVo.getOptionList(), response);
                this.titleAnswerConvert(titleCode, subTitleVo.getTitleAnswer());
                if (StringUtils.isNotBlank((CharSequence)baseBookCode) && null == (bookTitleRefVo = this.titleMapper.getBaseBookTitleRef(baseBookCode, titleCode))) {
                    this.titleMapper.insertBaseBookTitleRef(baseBookCode, titleCode);
                }
                if (StringUtils.isNotBlank((CharSequence)formatSetPageCode) && null == (parentFormatPageRef = this.titleMapper.getParentFormatPageTitleRef(formatSetPageCode, titleCode))) {
                    this.titleMapper.insertParentFormatPageTitleRef(formatSetPageCode, titleCode);
                }
                List thirdTitleList = subTitleVo.getThirdTitleList();
                this.subTitleConvert(thirdTitleList, formatSetPageCode, baseBookCode, subTitleCode, response);
            }
        }
    }

    private void bookPageTitleRefConvert(BookPageTitleRefVo bookPageTitleRefVo, String titleCode) {
        if (null != bookPageTitleRefVo) {
            bookPageTitleRefVo.setTitleCode(titleCode);
            BookPageTitleRefDto bookPageTitleRefDto = this.bookPageTitleRefMapper.getBookPageTitleRef(bookPageTitleRefVo.getPageCode(), titleCode);
            if (null == bookPageTitleRefDto) {
                this.bookPageTitleRefMapper.insertBookPageTitleRef(bookPageTitleRefVo);
            } else {
                this.bookPageTitleRefMapper.updateBookPageTitleRef(bookPageTitleRefVo);
            }
        }
    }

    public boolean titleOptionConvert(String titleCode, String titleType, List<TitleOptionVo> titleOptionList, ResponseParams response) {
        String enumType;
        EnumDto enumDto = this.enumService.getEnumValueByCode(titleType, "TITLE");
        if (null == enumDto || StringUtils.isBlank((CharSequence)enumDto.getEnumType())) {
            response.fillError("\u9898\u76ee\u7c7b\u578b\u4e0d\u5b58\u5728", "3100010002");
            return false;
        }
        switch (enumType = enumDto.getEnumType()) {
            case "TITLE_SINGLE_CHOICE": 
            case "TITLE_MULTIPLE_CHOICE": 
            case "TITLE_JUDGMENT_QUESTIONS": {
                if (!CollectionUtils.isNotEmpty(titleOptionList)) break;
                ArrayList<TitleOptionVo> newTitleOptionList = new ArrayList<TitleOptionVo>(titleOptionList.size());
                int idx = 1;
                for (TitleOptionVo titleOptionVo : titleOptionList) {
                    String optionCode = CoreUtil.createCommonsCore((String)"TO", (int)10);
                    titleOptionVo.setTitleCode(titleCode);
                    titleOptionVo.setOptionCode(optionCode);
                    titleOptionVo.setIdx(Integer.valueOf(idx++));
                    newTitleOptionList.add(titleOptionVo);
                }
                this.titleOptionMapper.batchInsertTitleOption(newTitleOptionList);
            }
        }
        return true;
    }

    public void titleAnswerConvert(String titleCode, TitleAnswerVo titleAnswer) {
        if (null != titleAnswer) {
            this.titleAnswerMapper.deleteByTitleCode(titleCode);
            String answerCode = CoreUtil.createCommonsCore((String)"TA", (int)10);
            titleAnswer.setTitleCode(titleCode);
            titleAnswer.setAnswerCode(answerCode);
            this.titleAnswerMapper.insertSelective(titleAnswer);
        }
    }

    public List<TitleDto> listTitle(TitleVo titleVo) {
        List titleList = this.titleMapper.getQuestionList(titleVo);
        if (CollectionUtils.isNotEmpty((Collection)titleList)) {
            ArrayList<TitleDto> newTitleList = new ArrayList<TitleDto>(titleList.size());
            for (TitleDto title : titleList) {
                TitleDto titleDto = this.titleInfoConvert(title, title.getTitleCode());
                newTitleList.add(titleDto);
            }
            return newTitleList;
        }
        return titleList;
    }

    public TitleDto getTitleInfo(TitleVo titleVo) {
        TitleDto title = this.titleMapper.getTitleByTitleCode(titleVo.getTitleCode());
        if (null == title) {
            return null;
        }
        title = this.titleInfoConvert(title, titleVo.getTitleCode());
        return title;
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean deleteTitle(TitleVo titleVo) {
        int result = this.titleMapper.deleteByTitleCode(titleVo.getTitleCode());
        this.titleAnswerMapper.deleteByTitleCode(titleVo.getTitleCode());
        this.titleOptionMapper.deleteByTitleCode(titleVo.getTitleCode());
        this.titleMapper.deleteBaseBookTitleRef(null, titleVo.getTitleCode());
        this.titleMapper.deleteParentFormatPageTitleRef(null, titleVo.getTitleCode());
        return result > 0;
    }

    public TitleDto titleInfoConvert(TitleDto title, String titleCode) {
        List titleOptionList = this.titleOptionMapper.getTitleOptionByTitleCode(titleCode);
        title.setQuestionOptionList(titleOptionList);
        List titleAnswerList = this.titleAnswerMapper.getQuestionAnswerByTitleCode(titleCode);
        title.setQuestionAnswerList(titleAnswerList);
        return title;
    }
}

