/*
 * Decompiled with CFR 0.152.
 */
package ella.composition.server.service.impl;

import com.ella.entity.composition.dto.TitleExtendDto;
import com.ella.entity.composition.vo.ExtendVo;
import com.ella.entity.composition.vo.TitleExtendVo;
import com.ella.response.ResponseParams;
import com.ella.util.CoreUtil;
import ella.composition.server.mapper.ExtendMapper;
import ella.composition.server.mapper.TitleExtendMapper;
import ella.composition.server.service.EnumService;
import ella.composition.server.service.TitleExtendService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class TitleExtendServiceImpl
implements TitleExtendService {
    @Resource
    TitleExtendMapper titleExtendMapper;
    @Resource
    ExtendMapper extendMapper;
    @Resource
    EnumService enumService;

    public ResponseParams addTitleExtend(TitleExtendVo titleExtendVo, ResponseParams response) {
        String extendCode = CoreUtil.createCommonsCore((String)"TE", (int)4);
        titleExtendVo.setExtendCode(extendCode);
        int result = this.titleExtendMapper.addTitleExtend(titleExtendVo);
        if (result > 0) {
            HashMap<String, String> resultMap = new HashMap<String, String>(1);
            resultMap.put("extendCode", extendCode);
            response.fillSuccess(resultMap);
        }
        return response;
    }

    public ResponseParams updateTitleExtend(TitleExtendVo titleExtendVo, ResponseParams response) {
        if (StringUtils.isBlank((CharSequence)titleExtendVo.getExtendCode())) {
            response.fillError("\u9898\u76ee\u6269\u5c55\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a", "3100020001");
            return response;
        }
        int result = this.titleExtendMapper.updateTitleExtend(titleExtendVo);
        response.fillSuccess((Object)(result > 0 ? 1 : 0));
        return response;
    }

    public List<TitleExtendDto> listTitleExtend(TitleExtendVo titleExtendVo) {
        return null;
    }

    public TitleExtendDto getTitleExtendInfo(TitleExtendVo titleExtendVo) {
        TitleExtendDto titleExtendDto = this.titleExtendMapper.getTitleExtendInfo(titleExtendVo);
        return titleExtendDto;
    }

    public boolean deleteTitleExtend(TitleExtendVo titleExtendVo) {
        int result = this.titleExtendMapper.deleteTitleExtend(titleExtendVo);
        return result > 0;
    }

    public ResponseParams addExtend(ExtendVo extendVo, ResponseParams response) {
        if (StringUtils.isBlank((CharSequence)extendVo.getSectionCode()) && StringUtils.isBlank((CharSequence)extendVo.getExtendName())) {
            response.fillError("\u5b66\u6bb5\u4e0d\u80fd\u4e3a\u7a7a", "3100020002");
            return response;
        }
        String sectionCode = StringUtils.isNotBlank((CharSequence)extendVo.getSectionName()) ? this.enumService.addEnum(extendVo.getSectionName(), "SCHOOL", "\u5b66\u6bb5") : extendVo.getSectionCode();
        String tagCode = this.enumService.addEnum(extendVo.getExtendName(), "TAG", "\u6807\u7b7e");
        ArrayList<ExtendVo> extendVoList = new ArrayList<ExtendVo>();
        String[] subjectArr = extendVo.getSubjectCodeArr().split(",");
        for (int i = 0; i < subjectArr.length; ++i) {
            String extendCode1 = CoreUtil.createCommonsCore((String)"TE", (int)4);
            ExtendVo extend1 = new ExtendVo(extendCode1, subjectArr[i], sectionCode, Integer.valueOf(2));
            extendVoList.add(extend1);
            String extendCode2 = CoreUtil.createCommonsCore((String)"TE", (int)4);
            ExtendVo extend2 = new ExtendVo(extendCode2, tagCode, subjectArr[i], Integer.valueOf(3));
            extendVoList.add(extend2);
        }
        int result = this.extendMapper.addExtend(extendVoList);
        response.fillSuccess((Object)(result > 0 ? 1 : 0));
        return response;
    }
}

