/*
 * Decompiled with CFR 0.152.
 */
package ella.composition.server.service.impl;

import com.ella.entity.composition.dto.SourceMaterialDto;
import com.ella.entity.composition.vo.SourceMaterialVo;
import com.ella.entity.dto.ResponsePageResultDto;
import com.ella.response.ResponseParams;
import com.ella.util.CoreUtil;
import com.ella.util.ResponsePageResultUtils;
import com.github.pagehelper.PageHelper;
import ella.composition.server.mapper.SourceMaterialMapper;
import ella.composition.server.service.EnumService;
import ella.composition.server.service.ProjectService;
import ella.composition.server.service.SourceMaterialService;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class SourceMaterialServiceImpl
implements SourceMaterialService {
    @Resource
    SourceMaterialMapper sourceMaterialMapper;
    @Resource
    ProjectService projectService;
    @Resource
    EnumService enumService;

    public ResponseParams addSourceMaterial(ResponseParams response, SourceMaterialVo sourceMaterialVo) {
        String smCode = CoreUtil.createCommonsCore((String)"SM", (int)4);
        boolean enumCheck = this.enumService.checkEnumValue(sourceMaterialVo.getSourceType(), "SOURCE_MATERIAL");
        if (!enumCheck) {
            response.fillError("\u9879\u76ee\u7d20\u6750\u7c7b\u578b\u9519\u8bef", "6100010001");
            return response;
        }
        sourceMaterialVo.setSmCode(smCode);
        int result = this.sourceMaterialMapper.addSourceMaterial(sourceMaterialVo);
        if (StringUtils.isNotBlank((CharSequence)sourceMaterialVo.getProjectCode())) {
            boolean projectCheck = this.projectService.checkProject(sourceMaterialVo.getProjectCode());
            if (!projectCheck) {
                response.fillError("\u9879\u76ee\u7f16\u53f7\u9519\u8bef", "1100010001");
                return response;
            }
            this.sourceMaterialMapper.insertSourceMaterialRef(sourceMaterialVo.getProjectCode(), smCode);
        }
        return response.fillSuccess((Object)(result > 0 ? 1 : 0));
    }

    public ResponseParams updateSourceMaterial(ResponseParams response, SourceMaterialVo sourceMaterialVo) {
        boolean enumCheck = this.enumService.checkEnumValue(sourceMaterialVo.getSourceType(), "SOURCE_MATERIAL");
        if (StringUtils.isBlank((CharSequence)sourceMaterialVo.getSmCode())) {
            response.fillError("\u9879\u76ee\u7d20\u6750\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a", "6100010001");
            return response;
        }
        if (!enumCheck) {
            response.fillError("\u9879\u76ee\u7d20\u6750\u7c7b\u578b\u9519\u8bef", "6100010001");
            return response;
        }
        int result = this.sourceMaterialMapper.updateSourceMaterial(sourceMaterialVo);
        return response.fillSuccess((Object)(result > 0 ? 1 : 0));
    }

    public boolean deleteSourceMaterial(SourceMaterialVo sourceMaterialVo) {
        int result = this.sourceMaterialMapper.deleteSourceMaterial(sourceMaterialVo);
        return result > 0;
    }

    public ResponsePageResultDto listSourceMaterial(SourceMaterialVo sourceMaterialVo) {
        PageHelper.startPage((int)sourceMaterialVo.getPageNum(), (int)sourceMaterialVo.getPageSize());
        List formulaDtoList = this.sourceMaterialMapper.listSourceMaterial(sourceMaterialVo);
        return ResponsePageResultUtils.build((List)formulaDtoList);
    }

    public SourceMaterialDto getSourceMaterialDetail(SourceMaterialVo sourceMaterialVo) {
        SourceMaterialDto sourceMaterial = this.sourceMaterialMapper.getSourceMaterialDetail(sourceMaterialVo);
        return sourceMaterial;
    }
}

