/*
 * Decompiled with CFR 0.152.
 */
package ella.composition.server.service.impl;

import com.ella.entity.composition.dto.FormatSetDto;
import com.ella.entity.composition.dto.ParentFormatDto;
import com.ella.entity.composition.dto.ParentFormatPageDto;
import com.ella.entity.composition.vo.ParentFormatPageEyebrowVo;
import com.ella.entity.composition.vo.ParentFormatPageNumVo;
import com.ella.entity.composition.vo.ParentFormatPageVo;
import com.ella.entity.composition.vo.ParentFormatVo;
import com.ella.entity.dto.ResponsePageResultDto;
import com.ella.response.ResponseParams;
import com.ella.util.CoreUtil;
import com.ella.util.ResponsePageResultUtils;
import com.github.pagehelper.PageHelper;
import ella.composition.server.mapper.FormatMapper;
import ella.composition.server.mapper.ParentFormatMapper;
import ella.composition.server.mapper.ParentFormatPageEyebrowMapper;
import ella.composition.server.mapper.ParentFormatPageMapper;
import ella.composition.server.mapper.ParentFormatPageNumMapper;
import ella.composition.server.service.ParentFormatService;
import ella.composition.server.service.ProjectService;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ParentFormatServiceImpl
implements ParentFormatService {
    @Resource
    ProjectService projectService;
    @Resource
    ParentFormatMapper parentFormatMapper;
    @Resource
    FormatMapper formatMapper;
    @Resource
    ParentFormatPageMapper parentFormatPageMapper;
    @Resource
    ParentFormatPageNumMapper parentFormatPageNumMapper;
    @Resource
    ParentFormatPageEyebrowMapper parentFormatPageEyebrowMapper;

    @Transactional(rollbackFor={Exception.class})
    public ResponseParams addParentFormatSet(ResponseParams response, ParentFormatVo parentFormatVo) {
        boolean projectCheck = this.projectService.checkProject(parentFormatVo.getProjectCode());
        if (!projectCheck) {
            response.fillError("1100010001", "\u9879\u76ee\u7f16\u53f7\u9519\u8bef");
            return response;
        }
        String parentFormatCode = CoreUtil.createCommonsCore((String)"PFS", (int)8);
        parentFormatVo.setParentFormatSetCode(parentFormatCode);
        List parentFormatPageList = parentFormatVo.getParentFormatPageList();
        if (CollectionUtils.isNotEmpty((Collection)parentFormatPageList)) {
            for (ParentFormatPageVo parentFormatPageVo : parentFormatPageList) {
                parentFormatPageVo.setParentFormatSetCode(parentFormatCode);
                this.addParentFormatPage(parentFormatPageVo);
            }
        }
        this.formatMapper.addFormatSet(parentFormatVo);
        int result = this.parentFormatMapper.addParentFormatSet(parentFormatVo);
        if (result > 0) {
            response.fillSuccess((Object)parentFormatVo);
        }
        return response;
    }

    @Transactional(rollbackFor={Exception.class})
    public ResponseParams updateParentFormatSet(ResponseParams response, ParentFormatVo parentFormatVo) {
        boolean projectCheck = this.projectService.checkProject(parentFormatVo.getProjectCode());
        if (!projectCheck) {
            response.fillError("1100010001", "\u9879\u76ee\u7f16\u53f7\u9519\u8bef");
            return response;
        }
        if (StringUtils.isBlank((CharSequence)parentFormatVo.getParentFormatSetCode())) {
            response.fillError("\u6bcd\u7248\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a", "2100010002");
            return response;
        }
        List parentFormatPageList = parentFormatVo.getParentFormatPageList();
        if (CollectionUtils.isNotEmpty((Collection)parentFormatPageList)) {
            this.deleteParentFormatSetPageByPfsCode(parentFormatVo.getParentFormatSetCode());
            for (ParentFormatPageVo parentFormatPageVo : parentFormatPageList) {
                parentFormatPageVo.setParentFormatSetCode(parentFormatVo.getParentFormatSetCode());
                this.addParentFormatPage(parentFormatPageVo);
            }
        }
        this.formatMapper.updateFormatSet(parentFormatVo);
        int result = this.parentFormatMapper.updateParentFormatSet(parentFormatVo);
        response.fillSuccess((Object)(result > 0 ? 1 : 0));
        return response;
    }

    public ParentFormatDto getParentFormatSetDetail(ParentFormatVo parentFormatVo) {
        ParentFormatDto parentFormatDto = this.parentFormatMapper.getParentFormatSetDetail(parentFormatVo);
        if (null != parentFormatDto) {
            FormatSetDto formatSetDto = this.formatMapper.getFormatSet(parentFormatDto.getFormatSetCode());
            parentFormatDto.setFormatSet(formatSetDto);
        }
        return parentFormatDto;
    }

    @Transactional(rollbackFor={Exception.class})
    public ResponseParams addParentFormatPage(ResponseParams response, ParentFormatPageVo parentFormatPageVo) {
        boolean result = this.addParentFormatPage(parentFormatPageVo);
        response.fillSuccess((Object)result);
        return response;
    }

    public boolean addParentFormatPage(ParentFormatPageVo parentFormatPageVo) {
        String pageCode = CoreUtil.createCommonsCore((String)"PFSP", (int)8);
        parentFormatPageVo.setPfsPageCode(pageCode);
        this.parentFormatPageNumAddConvert(pageCode, parentFormatPageVo.getPageNumList());
        this.parentFormatPageEyebrowAddConvert(pageCode, parentFormatPageVo.getPageEyebrowList());
        int result = this.parentFormatPageMapper.addParentFormatSetPage(parentFormatPageVo);
        return result > 0;
    }

    @Transactional(rollbackFor={Exception.class})
    public ResponseParams updateParentFormatPage(ResponseParams response, ParentFormatPageVo parentFormatPageVo) {
        String pageCode = parentFormatPageVo.getPfsPageCode();
        this.parentFormatPageNumMapper.deleteParentFormatSetPageNum(pageCode);
        this.parentFormatPageNumAddConvert(pageCode, parentFormatPageVo.getPageNumList());
        this.parentFormatPageEyebrowMapper.deleteParentFormatSetPageEyebrow(pageCode);
        this.parentFormatPageEyebrowAddConvert(pageCode, parentFormatPageVo.getPageEyebrowList());
        int result = this.parentFormatPageMapper.updateParentFormatSetPage(parentFormatPageVo);
        response.fillSuccess((Object)(result > 0 ? 1 : 0));
        return response;
    }

    public ParentFormatPageDto getParentFormatSetPageDetail(ParentFormatPageVo formatPageVo) {
        ParentFormatPageDto parentFormatPage = this.parentFormatPageMapper.getParentFormatSetPageDetail(formatPageVo);
        if (null != parentFormatPage) {
            List pageNumList = this.parentFormatPageNumMapper.getParentFormatSetPageNumList(formatPageVo.getPfsPageCode());
            parentFormatPage.setPageNumList(pageNumList);
            List eyebrowList = this.parentFormatPageEyebrowMapper.getParentFormatSetPageEyebrowList(formatPageVo.getPfsPageCode());
            parentFormatPage.setPageEyebrowList(eyebrowList);
        }
        return parentFormatPage;
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean deleteParentFormatSetPage(ParentFormatPageVo parentFormatPageVo) {
        String pageCode = parentFormatPageVo.getPfsPageCode();
        int result = this.parentFormatPageMapper.deleteParentFormatSetPage(pageCode);
        return result > 0;
    }

    public boolean deleteParentFormatSetPageByPfsCode(String parentSetCode) {
        int result = this.parentFormatPageMapper.deleteParentFormatSetPageByPfsCode(parentSetCode);
        return result > 0;
    }

    public ResponsePageResultDto listParentFormatSetPage(ParentFormatPageVo parentFormatPageVo) {
        PageHelper.startPage((int)parentFormatPageVo.getPageNum(), (int)parentFormatPageVo.getPageSize());
        List pageDtoListList = this.parentFormatPageMapper.listParentFormatSetPage(parentFormatPageVo.getParentFormatSetCode());
        if (CollectionUtils.isNotEmpty((Collection)pageDtoListList)) {
            for (ParentFormatPageDto parentFormatPage : pageDtoListList) {
                List pageNumList = this.parentFormatPageNumMapper.getParentFormatSetPageNumList(parentFormatPage.getPfsPageCode());
                parentFormatPage.setPageNumList(pageNumList);
                List eyebrowList = this.parentFormatPageEyebrowMapper.getParentFormatSetPageEyebrowList(parentFormatPage.getPfsPageCode());
                parentFormatPage.setPageEyebrowList(eyebrowList);
            }
        }
        return ResponsePageResultUtils.build((List)pageDtoListList);
    }

    public boolean parentFormatPageNumAddConvert(String parentFormatPageCode, List<ParentFormatPageNumVo> parentFormatPageNumList) {
        if (CollectionUtils.isNotEmpty(parentFormatPageNumList)) {
            for (ParentFormatPageNumVo parentFormatPageNumVo : parentFormatPageNumList) {
                String pageNumCode = CoreUtil.createCommonsCore((String)"PFSPN", (int)8);
                parentFormatPageNumVo.setPfspNumCode(pageNumCode);
                parentFormatPageNumVo.setPfsPageCode(parentFormatPageCode);
                this.parentFormatPageNumMapper.addParentFormatSetPageNum(parentFormatPageNumVo);
            }
        }
        return true;
    }

    public boolean parentFormatPageEyebrowAddConvert(String parentFormatPageCode, List<ParentFormatPageEyebrowVo> parentFormatPageEyebrowList) {
        if (CollectionUtils.isNotEmpty(parentFormatPageEyebrowList)) {
            for (ParentFormatPageEyebrowVo parentFormatPageEyebrowVo : parentFormatPageEyebrowList) {
                String pageEyebrowCode = CoreUtil.createCommonsCore((String)"PFSPE", (int)8);
                parentFormatPageEyebrowVo.setPfspEyebrowCode(pageEyebrowCode);
                parentFormatPageEyebrowVo.setPfsPageCode(parentFormatPageCode);
                this.parentFormatPageEyebrowMapper.addParentFormatSetPageEyebrow(parentFormatPageEyebrowVo);
            }
        }
        return true;
    }
}

