/*
 * Decompiled with CFR 0.152.
 */
package ella.composition.server.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ella.entity.composition.dto.EnumDto;
import com.ella.entity.composition.vo.EnumVo;
import com.ella.util.CoreUtil;
import ella.composition.server.client.RedisUtil;
import ella.composition.server.mapper.EnumMapper;
import ella.composition.server.service.EnumService;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class EnumServiceImpl
implements EnumService {
    @Resource
    EnumMapper enumMapper;
    @Resource
    RedisUtil redisUtil;

    public EnumDto getEnumValueByCode(String enumCode, String enumType) {
        EnumDto enumDto;
        String redisKey = "ENUM:" + enumCode;
        String content = this.redisUtil.get(redisKey);
        if (StringUtils.isNotBlank((CharSequence)content)) {
            enumDto = (EnumDto)JSONObject.parseObject((String)content, EnumDto.class);
        } else {
            enumDto = this.enumMapper.getEnumValueByCode(enumCode, enumType);
            if (null != enumDto) {
                this.redisUtil.set(redisKey, JSONObject.toJSONString((Object)enumDto));
            }
        }
        return enumDto;
    }

    public boolean checkEnumValue(String enumCode, String enumType) {
        EnumDto enumDto = this.getEnumValueByCode(enumCode, enumType);
        return null != enumDto;
    }

    public String addEnum(String enumName, String enumType, String typeName) {
        String enumCode = CoreUtil.createCommonsCore((String)"ENUM", (int)0);
        String enumValue = "";
        if (enumType.equals("SCHOOL")) {
            enumValue = "SCHOOL_";
        } else if (enumType.equals("TAG")) {
            enumValue = "TAG_";
        }
        EnumVo enumVo = new EnumVo(enumCode, enumName, enumValue, "STRING", enumType, typeName, 1);
        int result = this.enumMapper.addEnum(enumVo);
        if (result > 0) {
            return enumCode;
        }
        return "";
    }
}

