/*
 * Decompiled with CFR 0.152.
 */
package ella.composition.server.service.impl;

import com.ella.entity.composition.dto.BookDto;
import com.ella.entity.composition.dto.FormatSetDto;
import com.ella.entity.composition.dto.ParentFormatDto;
import com.ella.entity.composition.vo.BookVo;
import com.ella.entity.dto.ResponsePageResultDto;
import com.ella.util.ResponsePageResultUtils;
import com.github.pagehelper.PageHelper;
import ella.composition.server.mapper.BookFormatMapper;
import ella.composition.server.mapper.BookMapper;
import ella.composition.server.mapper.ParentFormatMapper;
import ella.composition.server.service.BookService;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class BookServiceImpl
implements BookService {
    @Resource
    BookMapper bookMapper;
    @Resource
    BookFormatMapper bookFormatMapper;
    @Resource
    ParentFormatMapper parentFormatMapper;

    public ResponsePageResultDto listBook(BookVo bookVo) {
        if (null == bookVo) {
            bookVo = new BookVo();
        }
        PageHelper.startPage((int)bookVo.getPageNum(), (int)bookVo.getPageSize());
        List formulaDtoList = this.bookMapper.listBook(bookVo);
        ResponsePageResultDto pageResult = ResponsePageResultUtils.build((List)formulaDtoList);
        return pageResult;
    }

    public BookDto getBookDetail(BookVo bookVo) {
        BookDto book = this.bookMapper.getBookDetail(bookVo);
        if (null != book) {
            FormatSetDto bookFormat = this.bookFormatMapper.getBookFormat(bookVo.getBaseBookCode());
            book.setBookFormat(bookFormat);
            ParentFormatDto parentFormat = this.parentFormatMapper.getParentFormatByBook(bookVo.getBaseBookCode());
            book.setParentFormat(parentFormat);
        }
        return book;
    }
}

