/*
 * Decompiled with CFR 0.152.
 */
package ella.composition.server.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ella.entity.composition.dto.BookPageDto;
import com.ella.entity.composition.vo.BookPageJsonFileVo;
import com.ella.entity.composition.vo.BookPageVo;
import com.ella.entity.dto.ResponsePageResultDto;
import com.ella.response.ResponseParams;
import com.ella.util.CoreUtil;
import com.ella.util.ResponsePageResultUtils;
import com.github.pagehelper.PageHelper;
import ella.composition.server.mapper.BookPageJsonFileMapper;
import ella.composition.server.mapper.BookPageMapper;
import ella.composition.server.service.BookPageService;
import ella.composition.server.service.UserProcessNodeService;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class BookPageServiceImpl
implements BookPageService {
    @Resource
    BookPageMapper bookPageMapper;
    @Resource
    UserProcessNodeService userProcessNodeService;
    @Resource
    BookPageJsonFileMapper bookPageJsonFileMapper;

    public ResponseParams addBookPage(ResponseParams response, BookPageVo bookPageVo) {
        String bookPageCode = CoreUtil.createCommonsCore((String)"BP", (int)4);
        bookPageVo.setPageCode(bookPageCode);
        String bpjfCode = this.bookPageJsonFileConvert(bookPageCode, bookPageVo.getPageJsonUrl(), bookPageVo.getMd5());
        bookPageVo.setBpjfCode(bpjfCode);
        int result = this.bookPageMapper.addBookPage(bookPageVo);
        response.fillSuccess((Object)(result > 0 ? 1 : 0));
        return response;
    }

    public ResponseParams updateBookPage(ResponseParams response, BookPageVo bookPageVo) {
        String bpjfCode = this.bookPageJsonFileConvert(bookPageVo.getPageCode(), bookPageVo.getPageJsonUrl(), bookPageVo.getMd5());
        bookPageVo.setBpjfCode(bpjfCode);
        int result = this.bookPageMapper.updateBookPage(bookPageVo);
        response.fillSuccess((Object)(result > 0 ? 1 : 0));
        return response;
    }

    public boolean deleteBookPage(BookPageVo bookPageVo) {
        int result = this.bookPageMapper.deleteBookPage(bookPageVo);
        return result > 0;
    }

    public JSONObject listBookPage(BookPageVo bookPageVo) {
        PageHelper.startPage((int)bookPageVo.getPageNum(), (int)bookPageVo.getPageSize());
        List formulaDtoList = this.bookPageMapper.listBookPage(bookPageVo);
        ResponsePageResultDto pageResult = ResponsePageResultUtils.build((List)formulaDtoList);
        JSONObject jsonObject = JSONObject.parseObject((String)JSONObject.toJSONString((Object)pageResult));
        List userBookPurviewList = this.userProcessNodeService.getUserBookPageProcessNodeToArray(bookPageVo.getCustomParam(), bookPageVo.getBookCode());
        jsonObject.put("userBookPurview", (Object)userBookPurviewList);
        return jsonObject;
    }

    public BookPageDto getBookPageDetail(BookPageVo bookPageVo) {
        BookPageDto bookPage = this.bookPageMapper.getBookPageDetail(bookPageVo);
        List userBookPurviewList = this.userProcessNodeService.getUserBookPageProcessNodeToArray(bookPageVo.getCustomParam(), bookPageVo.getBookCode());
        bookPage.setUserBookPurview(userBookPurviewList);
        return bookPage;
    }

    public ResponsePageResultDto listBookPageBase(BookPageVo bookPageVo) {
        PageHelper.startPage((int)bookPageVo.getPageNum(), (int)bookPageVo.getPageSize());
        List formulaDtoList = this.bookPageMapper.listBookPageBase(bookPageVo);
        ResponsePageResultDto pageResult = ResponsePageResultUtils.build((List)formulaDtoList);
        return pageResult;
    }

    public ResponseParams updateBookPageBase(ResponseParams response, BookPageVo bookPageVo) {
        int result = this.bookPageMapper.updateBookPage(bookPageVo);
        response.fillSuccess((Object)(result > 0 ? 1 : 0));
        return response;
    }

    public String bookPageJsonFileConvert(String pageCode, String pageJsonUrl, String md5) {
        if (StringUtils.isNotBlank((CharSequence)pageJsonUrl)) {
            String bpjfCode = CoreUtil.createCommonsCore((String)"BPJF", (int)2);
            String version = CoreUtil.createCommonsCore((String)"");
            BookPageJsonFileVo bookPageJsonFileVo = new BookPageJsonFileVo(bpjfCode, pageCode, version, pageJsonUrl, md5);
            this.bookPageJsonFileMapper.addBookPageJsonFile(bookPageJsonFileVo);
            return bpjfCode;
        }
        return "";
    }
}

