/*
 * Decompiled with CFR 0.152.
 */
package ella.composition.server.controller;

import com.ella.entity.composition.dto.StyleDto;
import com.ella.entity.composition.vo.StyleVo;
import com.ella.entity.dto.ResponsePageResultDto;
import com.ella.response.ResponseParams;
import ella.composition.server.service.StyleService;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class StyleController {
    @Resource
    StyleService styleService;

    @RequestMapping(value={"/v1/addStyle"})
    public ResponseParams addStyle(@RequestBody @Valid StyleVo styleVo) {
        ResponseParams response = new ResponseParams("\u7f16\u6392\u5de5\u5177-\u65b0\u589e\u6837\u5f0f");
        response = this.styleService.addStyle(styleVo, response);
        return response;
    }

    @RequestMapping(value={"/v1/updateStyle"})
    public ResponseParams updateStyle(@RequestBody @Valid StyleVo styleVo) {
        ResponseParams response = new ResponseParams("\u7f16\u6392\u5de5\u5177-\u6837\u5f0f\u4fee\u6539");
        response = this.styleService.updateStyle(styleVo, response);
        return response;
    }

    @RequestMapping(value={"/v1/listStyle"})
    public ResponseParams listStyle(@RequestBody(required=false) StyleVo styleVo) {
        ResponseParams response = new ResponseParams("\u7f16\u6392\u5de5\u5177-\u67e5\u8be2\u6837\u5f0f\u5217\u8868");
        ResponsePageResultDto styleList = this.styleService.listStyle(styleVo);
        response.fillSuccess((Object)styleList);
        return response;
    }

    @RequestMapping(value={"/v1/getStyleInfo"})
    public ResponseParams getStyleInfo(@RequestBody StyleVo styleVo) {
        ResponseParams response = new ResponseParams("\u7f16\u6392\u5de5\u5177-\u67e5\u8be2\u6837\u5f0f\u8be6\u60c5");
        StyleDto styleDto = this.styleService.getStyleInfo(styleVo);
        response.fillSuccess((Object)styleDto);
        return response;
    }

    @RequestMapping(value={"/v1/deleteStyle"})
    public ResponseParams deleteStyle(@RequestBody StyleVo styleVo) {
        ResponseParams response = new ResponseParams("\u7f16\u6392\u5de5\u5177-\u6837\u5f0f\u5220\u9664");
        if (StringUtils.isBlank((CharSequence)styleVo.getStyleCode())) {
            response.fillError("\u9898\u76ee\u6269\u5c55\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a", "7100020001");
            return response;
        }
        boolean result = this.styleService.deleteStyle(styleVo);
        response.fillSuccess((Object)result);
        return response;
    }
}

