/*
 * Decompiled with CFR 0.152.
 */
package ella.composition.server.controller;

import com.ella.entity.composition.dto.SourceMaterialDto;
import com.ella.entity.composition.vo.SourceMaterialVo;
import com.ella.entity.dto.ResponsePageResultDto;
import com.ella.response.ResponseParams;
import ella.composition.server.service.SourceMaterialService;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class SourceMaterialController {
    @Resource
    SourceMaterialService sourceMaterialService;

    @RequestMapping(value={"/v1/addSourceMaterial"})
    public ResponseParams addSourceMaterial(@RequestBody @Valid SourceMaterialVo sourceMaterialVo) {
        ResponseParams response = new ResponseParams("\u7f16\u6392\u5de5\u5177-\u9879\u76ee\u7d20\u6750\u65b0\u589e");
        response = this.sourceMaterialService.addSourceMaterial(response, sourceMaterialVo);
        return response;
    }

    @RequestMapping(value={"/v1/updateSourceMaterial"})
    public ResponseParams updateSourceMaterial(@RequestBody @Valid SourceMaterialVo sourceMaterialVo) {
        ResponseParams response = new ResponseParams("\u7f16\u6392\u5de5\u5177-\u9879\u76ee\u7d20\u6750\u4fee\u6539");
        response = this.sourceMaterialService.updateSourceMaterial(response, sourceMaterialVo);
        return response;
    }

    @RequestMapping(value={"/v1/deleteSourceMaterial"})
    public ResponseParams deleteSourceMaterial(@RequestBody SourceMaterialVo sourceMaterialVo) {
        ResponseParams response = new ResponseParams("\u7f16\u6392\u5de5\u5177-\u9879\u76ee\u7d20\u6750\u5220\u9664");
        if (StringUtils.isBlank((CharSequence)sourceMaterialVo.getSmCode())) {
            response.fillError("\u9879\u76ee\u7d20\u6750\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a", "6100010001");
            return response;
        }
        boolean result = this.sourceMaterialService.deleteSourceMaterial(sourceMaterialVo);
        response.fillSuccess((Object)result);
        return response;
    }

    @RequestMapping(value={"/v1/getSourceMaterialDetail"})
    public ResponseParams getSourceMaterialDetail(@RequestBody SourceMaterialVo sourceMaterialVo) {
        ResponseParams response = new ResponseParams("\u7f16\u6392\u5de5\u5177-\u9879\u76ee\u7d20\u6750\u8be6\u60c5");
        if (StringUtils.isBlank((CharSequence)sourceMaterialVo.getSmCode())) {
            response.fillError("\u9879\u76ee\u7d20\u6750\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a", "6100010001");
            return response;
        }
        SourceMaterialDto sourceMaterial = this.sourceMaterialService.getSourceMaterialDetail(sourceMaterialVo);
        response.fillSuccess((Object)sourceMaterial);
        return response;
    }

    @RequestMapping(value={"/v1/listSourceMaterial"})
    public ResponseParams listSourceMaterial(@RequestBody(required=false) SourceMaterialVo sourceMaterialVo) {
        ResponseParams response = new ResponseParams("\u7f16\u6392\u5de5\u5177-\u9879\u76ee\u7d20\u6750\u5217\u8868");
        ResponsePageResultDto pageResult = this.sourceMaterialService.listSourceMaterial(sourceMaterialVo);
        response.fillSuccess((Object)pageResult);
        return response;
    }
}

