/*
 * Decompiled with CFR 0.152.
 */
package ella.composition.server.client;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CachingConfigurerSupport;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.stereotype.Component;

@Component
public class RedisUtil
extends CachingConfigurerSupport {
    @Autowired
    StringRedisTemplate stringRedisTemplate;

    public StringRedisTemplate getstringRedisTemplate() {
        return this.stringRedisTemplate;
    }

    public ValueOperations<String, String> opsForValue() {
        return this.stringRedisTemplate.opsForValue();
    }

    public boolean setExpireNX(String key, String value, long ttl) {
        boolean b = this.stringRedisTemplate.opsForValue().setIfAbsent((Object)key, (Object)value);
        if (b) {
            this.stringRedisTemplate.expire((Object)key, ttl, TimeUnit.SECONDS);
        }
        return b;
    }

    public void delete(String key) {
        this.stringRedisTemplate.delete((Object)key);
    }

    public void delete(Collection<String> keys) {
        this.stringRedisTemplate.delete(keys);
    }

    public byte[] dump(String key) {
        return this.stringRedisTemplate.dump((Object)key);
    }

    public Boolean hasKey(String key) {
        return this.stringRedisTemplate.hasKey((Object)key);
    }

    public Boolean expire(String key, long timeout, TimeUnit unit) {
        return this.stringRedisTemplate.expire((Object)key, timeout, unit);
    }

    public Boolean expireAt(String key, Date date) {
        return this.stringRedisTemplate.expireAt((Object)key, date);
    }

    public Set<String> keys(String pattern) {
        return this.stringRedisTemplate.keys((Object)pattern);
    }

    public Boolean move(String key, int dbIndex) {
        return this.stringRedisTemplate.move((Object)key, dbIndex);
    }

    public Boolean persist(String key) {
        return this.stringRedisTemplate.persist((Object)key);
    }

    public Long getExpire(String key, TimeUnit unit) {
        return this.stringRedisTemplate.getExpire((Object)key, unit);
    }

    public Long getExpire(String key) {
        return this.stringRedisTemplate.getExpire((Object)key);
    }

    public String randomKey() {
        return (String)this.stringRedisTemplate.randomKey();
    }

    public void rename(String oldKey, String newKey) {
        this.stringRedisTemplate.rename((Object)oldKey, (Object)newKey);
    }

    public Boolean renameIfAbsent(String oldKey, String newKey) {
        return this.stringRedisTemplate.renameIfAbsent((Object)oldKey, (Object)newKey);
    }

    public DataType type(String key) {
        return this.stringRedisTemplate.type((Object)key);
    }

    public void set(String key, String value) {
        this.stringRedisTemplate.opsForValue().set((Object)key, (Object)value);
    }

    public void set(String key, String value, long expire) {
        this.stringRedisTemplate.opsForValue().set((Object)key, (Object)value, expire, TimeUnit.SECONDS);
    }

    public String get(String key) {
        return (String)this.stringRedisTemplate.opsForValue().get((Object)key);
    }

    public String getRange(String key, long start, long end) {
        return this.stringRedisTemplate.opsForValue().get((Object)key, start, end);
    }

    public String getAndSet(String key, String value) {
        return (String)this.stringRedisTemplate.opsForValue().getAndSet((Object)key, (Object)value);
    }

    public Boolean getBit(String key, long offset) {
        return this.stringRedisTemplate.opsForValue().getBit((Object)key, offset);
    }

    public List<String> multiGet(Collection<String> keys) {
        return this.stringRedisTemplate.opsForValue().multiGet(keys);
    }

    public boolean setBit(String key, long offset, boolean value) {
        return this.stringRedisTemplate.opsForValue().setBit((Object)key, offset, value);
    }

    public void setEx(String key, String value, long timeout, TimeUnit unit) {
        this.stringRedisTemplate.opsForValue().set((Object)key, (Object)value, timeout, unit);
    }

    public boolean setIfAbsent(String key, String value) {
        return this.stringRedisTemplate.opsForValue().setIfAbsent((Object)key, (Object)value);
    }

    public void setRange(String key, String value, long offset) {
        this.stringRedisTemplate.opsForValue().set((Object)key, (Object)value, offset);
    }

    public Long size(String key) {
        return this.stringRedisTemplate.opsForValue().size((Object)key);
    }

    public void multiSet(Map<String, String> maps) {
        this.stringRedisTemplate.opsForValue().multiSet(maps);
    }

    public boolean multiSetIfAbsent(Map<String, String> maps) {
        return this.stringRedisTemplate.opsForValue().multiSetIfAbsent(maps);
    }

    public Long incrBy(String key, long increment) {
        return this.stringRedisTemplate.opsForValue().increment((Object)key, increment);
    }

    public Double incrByFloat(String key, double increment) {
        return this.stringRedisTemplate.opsForValue().increment((Object)key, increment);
    }

    public Integer append(String key, String value) {
        return this.stringRedisTemplate.opsForValue().append((Object)key, value);
    }

    public Object hGet(String key, String field) {
        return this.stringRedisTemplate.opsForHash().get((Object)key, (Object)field);
    }

    public Map<Object, Object> hGetAll(String key) {
        return this.stringRedisTemplate.opsForHash().entries((Object)key);
    }

    public List<Object> hMultiGet(String key, Collection<Object> fields) {
        return this.stringRedisTemplate.opsForHash().multiGet((Object)key, fields);
    }

    public void hPut(String key, String hashKey, String value) {
        this.stringRedisTemplate.opsForHash().put((Object)key, (Object)hashKey, (Object)value);
    }

    public void hPutAll(String key, Map<String, String> maps) {
        this.stringRedisTemplate.opsForHash().putAll((Object)key, maps);
    }

    public Boolean hPutIfAbsent(String key, String hashKey, String value) {
        return this.stringRedisTemplate.opsForHash().putIfAbsent((Object)key, (Object)hashKey, (Object)value);
    }

    public Long hDelete(String key, Object ... fields) {
        return this.stringRedisTemplate.opsForHash().delete((Object)key, fields);
    }

    public boolean hExists(String key, String field) {
        return this.stringRedisTemplate.opsForHash().hasKey((Object)key, (Object)field);
    }

    public Long hIncrBy(String key, Object field, long increment) {
        return this.stringRedisTemplate.opsForHash().increment((Object)key, field, increment);
    }

    public Double hIncrByFloat(String key, Object field, double delta) {
        return this.stringRedisTemplate.opsForHash().increment((Object)key, field, delta);
    }

    public Set<Object> hKeys(String key) {
        return this.stringRedisTemplate.opsForHash().keys((Object)key);
    }

    public Long hSize(String key) {
        return this.stringRedisTemplate.opsForHash().size((Object)key);
    }

    public List<Object> hValues(String key) {
        return this.stringRedisTemplate.opsForHash().values((Object)key);
    }

    public Cursor<Map.Entry<Object, Object>> hScan(String key, ScanOptions options) {
        return this.stringRedisTemplate.opsForHash().scan((Object)key, options);
    }

    public String lIndex(String key, long index) {
        return (String)this.stringRedisTemplate.opsForList().index((Object)key, index);
    }

    public List<String> lRange(String key, long start, long end) {
        return this.stringRedisTemplate.opsForList().range((Object)key, start, end);
    }

    public Long lLeftPush(String key, String value) {
        return this.stringRedisTemplate.opsForList().leftPush((Object)key, (Object)value);
    }

    public Long lLeftPushAll(String key, String ... value) {
        return this.stringRedisTemplate.opsForList().leftPushAll((Object)key, (Object[])value);
    }

    public Long lLeftPushAll(String key, Collection<String> value) {
        return this.stringRedisTemplate.opsForList().leftPushAll((Object)key, value);
    }

    public Long lLeftPushIfPresent(String key, String value) {
        return this.stringRedisTemplate.opsForList().leftPushIfPresent((Object)key, (Object)value);
    }

    public Long lLeftPush(String key, String pivot, String value) {
        return this.stringRedisTemplate.opsForList().leftPush((Object)key, (Object)pivot, (Object)value);
    }

    public Long lRightPush(String key, String value) {
        return this.stringRedisTemplate.opsForList().rightPush((Object)key, (Object)value);
    }

    public Long lRightPushAll(String key, String ... value) {
        return this.stringRedisTemplate.opsForList().rightPushAll((Object)key, (Object[])value);
    }

    public Long lRightPushAll(String key, Collection<String> value) {
        return this.stringRedisTemplate.opsForList().rightPushAll((Object)key, value);
    }

    public Long lRightPushIfPresent(String key, String value) {
        return this.stringRedisTemplate.opsForList().rightPushIfPresent((Object)key, (Object)value);
    }

    public Long lRightPush(String key, String pivot, String value) {
        return this.stringRedisTemplate.opsForList().rightPush((Object)key, (Object)pivot, (Object)value);
    }

    public void lSet(String key, long index, String value) {
        this.stringRedisTemplate.opsForList().set((Object)key, index, (Object)value);
    }

    public String lLeftPop(String key) {
        return (String)this.stringRedisTemplate.opsForList().leftPop((Object)key);
    }

    public String lBLeftPop(String key, long timeout, TimeUnit unit) {
        return (String)this.stringRedisTemplate.opsForList().leftPop((Object)key, timeout, unit);
    }

    public String lRightPop(String key) {
        return (String)this.stringRedisTemplate.opsForList().rightPop((Object)key);
    }

    public String lBRightPop(String key, long timeout, TimeUnit unit) {
        return (String)this.stringRedisTemplate.opsForList().rightPop((Object)key, timeout, unit);
    }

    public String lRightPopAndLeftPush(String sourceKey, String destinationKey) {
        return (String)this.stringRedisTemplate.opsForList().rightPopAndLeftPush((Object)sourceKey, (Object)destinationKey);
    }

    public String lBRightPopAndLeftPush(String sourceKey, String destinationKey, long timeout, TimeUnit unit) {
        return (String)this.stringRedisTemplate.opsForList().rightPopAndLeftPush((Object)sourceKey, (Object)destinationKey, timeout, unit);
    }

    public Long lRemove(String key, long index, String value) {
        return this.stringRedisTemplate.opsForList().remove((Object)key, index, (Object)value);
    }

    public void lTrim(String key, long start, long end) {
        this.stringRedisTemplate.opsForList().trim((Object)key, start, end);
    }

    public Long lLen(String key) {
        return this.stringRedisTemplate.opsForList().size((Object)key);
    }

    public Long sAdd(String key, String ... values) {
        return this.stringRedisTemplate.opsForSet().add((Object)key, (Object[])values);
    }

    public Long sRemove(String key, Object ... values) {
        return this.stringRedisTemplate.opsForSet().remove((Object)key, values);
    }

    public String sPop(String key) {
        return (String)this.stringRedisTemplate.opsForSet().pop((Object)key);
    }

    public Boolean sMove(String key, String value, String destKey) {
        return this.stringRedisTemplate.opsForSet().move((Object)key, (Object)value, (Object)destKey);
    }

    public Long sSize(String key) {
        return this.stringRedisTemplate.opsForSet().size((Object)key);
    }

    public Boolean sIsMember(String key, Object value) {
        return this.stringRedisTemplate.opsForSet().isMember((Object)key, value);
    }

    public Set<String> sIntersect(String key, String otherKey) {
        return this.stringRedisTemplate.opsForSet().intersect((Object)key, (Object)otherKey);
    }

    public Set<String> sIntersect(String key, Collection<String> otherKeys) {
        return this.stringRedisTemplate.opsForSet().intersect((Object)key, otherKeys);
    }

    public Long sIntersectAndStore(String key, String otherKey, String destKey) {
        return this.stringRedisTemplate.opsForSet().intersectAndStore((Object)key, (Object)otherKey, (Object)destKey);
    }

    public Long sIntersectAndStore(String key, Collection<String> otherKeys, String destKey) {
        return this.stringRedisTemplate.opsForSet().intersectAndStore((Object)key, otherKeys, (Object)destKey);
    }

    public Set<String> sUnion(String key, String otherKeys) {
        return this.stringRedisTemplate.opsForSet().union((Object)key, (Object)otherKeys);
    }

    public Set<String> sUnion(String key, Collection<String> otherKeys) {
        return this.stringRedisTemplate.opsForSet().union((Object)key, otherKeys);
    }

    public Long sUnionAndStore(String key, String otherKey, String destKey) {
        return this.stringRedisTemplate.opsForSet().unionAndStore((Object)key, (Object)otherKey, (Object)destKey);
    }

    public Long sUnionAndStore(String key, Collection<String> otherKeys, String destKey) {
        return this.stringRedisTemplate.opsForSet().unionAndStore((Object)key, otherKeys, (Object)destKey);
    }

    public Set<String> sDifference(String key, String otherKey) {
        return this.stringRedisTemplate.opsForSet().difference((Object)key, (Object)otherKey);
    }

    public Set<String> sDifference(String key, Collection<String> otherKeys) {
        return this.stringRedisTemplate.opsForSet().difference((Object)key, otherKeys);
    }

    public Long sDifference(String key, String otherKey, String destKey) {
        return this.stringRedisTemplate.opsForSet().differenceAndStore((Object)key, (Object)otherKey, (Object)destKey);
    }

    public Long sDifference(String key, Collection<String> otherKeys, String destKey) {
        return this.stringRedisTemplate.opsForSet().differenceAndStore((Object)key, otherKeys, (Object)destKey);
    }

    public Set<String> setMembers(String key) {
        return this.stringRedisTemplate.opsForSet().members((Object)key);
    }

    public String sRandomMember(String key) {
        return (String)this.stringRedisTemplate.opsForSet().randomMember((Object)key);
    }

    public List<String> sRandomMembers(String key, long count) {
        return this.stringRedisTemplate.opsForSet().randomMembers((Object)key, count);
    }

    public Set<String> sDistinctRandomMembers(String key, long count) {
        return this.stringRedisTemplate.opsForSet().distinctRandomMembers((Object)key, count);
    }

    public Cursor<String> sScan(String key, ScanOptions options) {
        return this.stringRedisTemplate.opsForSet().scan((Object)key, options);
    }

    public Boolean zAdd(String key, String value, double score) {
        return this.stringRedisTemplate.opsForZSet().add((Object)key, (Object)value, score);
    }

    public Long zAdd(String key, Set<ZSetOperations.TypedTuple<String>> values) {
        return this.stringRedisTemplate.opsForZSet().add((Object)key, values);
    }

    public Long zRemove(String key, Object ... values) {
        return this.stringRedisTemplate.opsForZSet().remove((Object)key, values);
    }

    public Double zIncrementScore(String key, String value, double delta) {
        return this.stringRedisTemplate.opsForZSet().incrementScore((Object)key, (Object)value, delta);
    }

    public Long zRank(String key, Object value) {
        return this.stringRedisTemplate.opsForZSet().rank((Object)key, value);
    }

    public Long zReverseRank(String key, Object value) {
        return this.stringRedisTemplate.opsForZSet().reverseRank((Object)key, value);
    }

    public Set<String> zRange(String key, long start, long end) {
        return this.stringRedisTemplate.opsForZSet().range((Object)key, start, end);
    }

    public Set<ZSetOperations.TypedTuple<String>> zRangeWithScores(String key, long start, long end) {
        return this.stringRedisTemplate.opsForZSet().rangeWithScores((Object)key, start, end);
    }

    public Set<String> zRangeByScore(String key, double min, double max) {
        return this.stringRedisTemplate.opsForZSet().rangeByScore((Object)key, min, max);
    }

    public Set<ZSetOperations.TypedTuple<String>> zRangeByScoreWithScores(String key, double min, double max) {
        return this.stringRedisTemplate.opsForZSet().rangeByScoreWithScores((Object)key, min, max);
    }

    public Set<ZSetOperations.TypedTuple<String>> zRangeByScoreWithScores(String key, double min, double max, long start, long end) {
        return this.stringRedisTemplate.opsForZSet().rangeByScoreWithScores((Object)key, min, max, start, end);
    }

    public Set<String> zReverseRange(String key, long start, long end) {
        return this.stringRedisTemplate.opsForZSet().reverseRange((Object)key, start, end);
    }

    public Set<ZSetOperations.TypedTuple<String>> zReverseRangeWithScores(String key, long start, long end) {
        return this.stringRedisTemplate.opsForZSet().reverseRangeWithScores((Object)key, start, end);
    }

    public Set<String> zReverseRangeByScore(String key, double min, double max) {
        return this.stringRedisTemplate.opsForZSet().reverseRangeByScore((Object)key, min, max);
    }

    public Set<ZSetOperations.TypedTuple<String>> zReverseRangeByScoreWithScores(String key, double min, double max) {
        return this.stringRedisTemplate.opsForZSet().reverseRangeByScoreWithScores((Object)key, min, max);
    }

    public Set<String> zReverseRangeByScore(String key, double min, double max, long start, long end) {
        return this.stringRedisTemplate.opsForZSet().reverseRangeByScore((Object)key, min, max, start, end);
    }

    public Long zCount(String key, double min, double max) {
        return this.stringRedisTemplate.opsForZSet().count((Object)key, min, max);
    }

    public Long zSize(String key) {
        return this.stringRedisTemplate.opsForZSet().size((Object)key);
    }

    public Long zZCard(String key) {
        return this.stringRedisTemplate.opsForZSet().zCard((Object)key);
    }

    public Double zScore(String key, Object value) {
        return this.stringRedisTemplate.opsForZSet().score((Object)key, value);
    }

    public Long zRemoveRange(String key, long start, long end) {
        return this.stringRedisTemplate.opsForZSet().removeRange((Object)key, start, end);
    }

    public Long zRemoveRangeByScore(String key, double min, double max) {
        return this.stringRedisTemplate.opsForZSet().removeRangeByScore((Object)key, min, max);
    }

    public Long zUnionAndStore(String key, String otherKey, String destKey) {
        return this.stringRedisTemplate.opsForZSet().unionAndStore((Object)key, (Object)otherKey, (Object)destKey);
    }

    public Long zUnionAndStore(String key, Collection<String> otherKeys, String destKey) {
        return this.stringRedisTemplate.opsForZSet().unionAndStore((Object)key, otherKeys, (Object)destKey);
    }

    public Long zIntersectAndStore(String key, String otherKey, String destKey) {
        return this.stringRedisTemplate.opsForZSet().intersectAndStore((Object)key, (Object)otherKey, (Object)destKey);
    }

    public Long zIntersectAndStore(String key, Collection<String> otherKeys, String destKey) {
        return this.stringRedisTemplate.opsForZSet().intersectAndStore((Object)key, otherKeys, (Object)destKey);
    }

    public Cursor<ZSetOperations.TypedTuple<String>> zScan(String key, ScanOptions options) {
        return this.stringRedisTemplate.opsForZSet().scan((Object)key, options);
    }
}

