/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.vendor.shipments.v1;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import software.amazon.spapi.models.vendor.shipments.v1.PartyIdentification;

@Schema(description="Vendor Details as part of Label response.")
public class VendorDetails {
    @SerializedName(value="sellingParty")
    private PartyIdentification sellingParty = null;
    @SerializedName(value="vendorShipmentIdentifier")
    private String vendorShipmentIdentifier = null;

    public VendorDetails sellingParty(PartyIdentification sellingParty) {
        this.sellingParty = sellingParty;
        return this;
    }

    @Schema(description="")
    public PartyIdentification getSellingParty() {
        return this.sellingParty;
    }

    public void setSellingParty(PartyIdentification sellingParty) {
        this.sellingParty = sellingParty;
    }

    public VendorDetails vendorShipmentIdentifier(String vendorShipmentIdentifier) {
        this.vendorShipmentIdentifier = vendorShipmentIdentifier;
        return this;
    }

    @Schema(description="Unique vendor shipment id which is not used in last 365 days")
    public String getVendorShipmentIdentifier() {
        return this.vendorShipmentIdentifier;
    }

    public void setVendorShipmentIdentifier(String vendorShipmentIdentifier) {
        this.vendorShipmentIdentifier = vendorShipmentIdentifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VendorDetails vendorDetails = (VendorDetails)o;
        return Objects.equals(this.sellingParty, vendorDetails.sellingParty) && Objects.equals(this.vendorShipmentIdentifier, vendorDetails.vendorShipmentIdentifier);
    }

    public int hashCode() {
        return Objects.hash(this.sellingParty, this.vendorShipmentIdentifier);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class VendorDetails {\n");
        sb.append("    sellingParty: ").append(this.toIndentedString(this.sellingParty)).append("\n");
        sb.append("    vendorShipmentIdentifier: ").append(this.toIndentedString(this.vendorShipmentIdentifier)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

