/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.vendor.shipments.v1;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import software.amazon.spapi.models.vendor.shipments.v1.Volume;
import software.amazon.spapi.models.vendor.shipments.v1.Weight;

@Schema(description="Shipment measurement details.")
public class ShipmentMeasurements {
    @SerializedName(value="grossShipmentWeight")
    private Weight grossShipmentWeight = null;
    @SerializedName(value="shipmentVolume")
    private Volume shipmentVolume = null;
    @SerializedName(value="cartonCount")
    private Integer cartonCount = null;
    @SerializedName(value="palletCount")
    private Integer palletCount = null;

    public ShipmentMeasurements grossShipmentWeight(Weight grossShipmentWeight) {
        this.grossShipmentWeight = grossShipmentWeight;
        return this;
    }

    @Schema(description="")
    public Weight getGrossShipmentWeight() {
        return this.grossShipmentWeight;
    }

    public void setGrossShipmentWeight(Weight grossShipmentWeight) {
        this.grossShipmentWeight = grossShipmentWeight;
    }

    public ShipmentMeasurements shipmentVolume(Volume shipmentVolume) {
        this.shipmentVolume = shipmentVolume;
        return this;
    }

    @Schema(description="")
    public Volume getShipmentVolume() {
        return this.shipmentVolume;
    }

    public void setShipmentVolume(Volume shipmentVolume) {
        this.shipmentVolume = shipmentVolume;
    }

    public ShipmentMeasurements cartonCount(Integer cartonCount) {
        this.cartonCount = cartonCount;
        return this;
    }

    @Schema(description="Number of cartons present in the shipment. Provide the cartonCount only for non-palletized shipments.")
    public Integer getCartonCount() {
        return this.cartonCount;
    }

    public void setCartonCount(Integer cartonCount) {
        this.cartonCount = cartonCount;
    }

    public ShipmentMeasurements palletCount(Integer palletCount) {
        this.palletCount = palletCount;
        return this;
    }

    @Schema(description="Number of pallets present in the shipment. Provide the palletCount only for palletized shipments.")
    public Integer getPalletCount() {
        return this.palletCount;
    }

    public void setPalletCount(Integer palletCount) {
        this.palletCount = palletCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShipmentMeasurements shipmentMeasurements = (ShipmentMeasurements)o;
        return Objects.equals(this.grossShipmentWeight, shipmentMeasurements.grossShipmentWeight) && Objects.equals(this.shipmentVolume, shipmentMeasurements.shipmentVolume) && Objects.equals(this.cartonCount, shipmentMeasurements.cartonCount) && Objects.equals(this.palletCount, shipmentMeasurements.palletCount);
    }

    public int hashCode() {
        return Objects.hash(this.grossShipmentWeight, this.shipmentVolume, this.cartonCount, this.palletCount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ShipmentMeasurements {\n");
        sb.append("    grossShipmentWeight: ").append(this.toIndentedString(this.grossShipmentWeight)).append("\n");
        sb.append("    shipmentVolume: ").append(this.toIndentedString(this.shipmentVolume)).append("\n");
        sb.append("    cartonCount: ").append(this.toIndentedString(this.cartonCount)).append("\n");
        sb.append("    palletCount: ").append(this.toIndentedString(this.palletCount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

