/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.vendor.shipments.v1;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.spapi.models.vendor.shipments.v1.Pagination;
import software.amazon.spapi.models.vendor.shipments.v1.Shipment;

@Schema(description="The request schema for the GetShipmentDetails operation.")
public class ShipmentDetails {
    @SerializedName(value="pagination")
    private Pagination pagination = null;
    @SerializedName(value="shipments")
    private List<Shipment> shipments = null;

    public ShipmentDetails pagination(Pagination pagination) {
        this.pagination = pagination;
        return this;
    }

    @Schema(description="")
    public Pagination getPagination() {
        return this.pagination;
    }

    public void setPagination(Pagination pagination) {
        this.pagination = pagination;
    }

    public ShipmentDetails shipments(List<Shipment> shipments) {
        this.shipments = shipments;
        return this;
    }

    public ShipmentDetails addShipmentsItem(Shipment shipmentsItem) {
        if (this.shipments == null) {
            this.shipments = new ArrayList<Shipment>();
        }
        this.shipments.add(shipmentsItem);
        return this;
    }

    @Schema(description="A list of one or more shipments with underlying details.")
    public List<Shipment> getShipments() {
        return this.shipments;
    }

    public void setShipments(List<Shipment> shipments) {
        this.shipments = shipments;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShipmentDetails shipmentDetails = (ShipmentDetails)o;
        return Objects.equals(this.pagination, shipmentDetails.pagination) && Objects.equals(this.shipments, shipmentDetails.shipments);
    }

    public int hashCode() {
        return Objects.hash(this.pagination, this.shipments);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ShipmentDetails {\n");
        sb.append("    pagination: ").append(this.toIndentedString(this.pagination)).append("\n");
        sb.append("    shipments: ").append(this.toIndentedString(this.shipments)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

