/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.vendor.shipments.v1;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.Objects;

@Schema(description="Duration after manufacturing date during which the product is valid for consumption.")
public class Duration {
    @SerializedName(value="durationUnit")
    private DurationUnitEnum durationUnit = null;
    @SerializedName(value="durationValue")
    private Integer durationValue = null;

    public Duration durationUnit(DurationUnitEnum durationUnit) {
        this.durationUnit = durationUnit;
        return this;
    }

    @Schema(required=true, description="Unit for duration.")
    public DurationUnitEnum getDurationUnit() {
        return this.durationUnit;
    }

    public void setDurationUnit(DurationUnitEnum durationUnit) {
        this.durationUnit = durationUnit;
    }

    public Duration durationValue(Integer durationValue) {
        this.durationValue = durationValue;
        return this;
    }

    @Schema(required=true, description="Value for the duration in terms of the durationUnit.")
    public Integer getDurationValue() {
        return this.durationValue;
    }

    public void setDurationValue(Integer durationValue) {
        this.durationValue = durationValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Duration duration = (Duration)o;
        return Objects.equals((Object)this.durationUnit, (Object)duration.durationUnit) && Objects.equals(this.durationValue, duration.durationValue);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.durationUnit, this.durationValue});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Duration {\n");
        sb.append("    durationUnit: ").append(this.toIndentedString((Object)this.durationUnit)).append("\n");
        sb.append("    durationValue: ").append(this.toIndentedString(this.durationValue)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum DurationUnitEnum {
        DAYS("Days"),
        MONTHS("Months");

        private String value;

        private DurationUnitEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static DurationUnitEnum fromValue(String input) {
            for (DurationUnitEnum b : DurationUnitEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<DurationUnitEnum> {
            public void write(JsonWriter jsonWriter, DurationUnitEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public DurationUnitEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return DurationUnitEnum.fromValue(value);
            }
        }
    }
}

