/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.vendor.shipments.v1;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.Objects;

@Schema(description="A list of carton identifiers.")
public class ContainerIdentification {
    @SerializedName(value="containerIdentificationType")
    private ContainerIdentificationTypeEnum containerIdentificationType = null;
    @SerializedName(value="containerIdentificationNumber")
    private String containerIdentificationNumber = null;

    public ContainerIdentification containerIdentificationType(ContainerIdentificationTypeEnum containerIdentificationType) {
        this.containerIdentificationType = containerIdentificationType;
        return this;
    }

    @Schema(required=true, description="The container identification type.")
    public ContainerIdentificationTypeEnum getContainerIdentificationType() {
        return this.containerIdentificationType;
    }

    public void setContainerIdentificationType(ContainerIdentificationTypeEnum containerIdentificationType) {
        this.containerIdentificationType = containerIdentificationType;
    }

    public ContainerIdentification containerIdentificationNumber(String containerIdentificationNumber) {
        this.containerIdentificationNumber = containerIdentificationNumber;
        return this;
    }

    @Schema(required=true, description="Container identification number that adheres to the definition of the container identification type.")
    public String getContainerIdentificationNumber() {
        return this.containerIdentificationNumber;
    }

    public void setContainerIdentificationNumber(String containerIdentificationNumber) {
        this.containerIdentificationNumber = containerIdentificationNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContainerIdentification containerIdentification = (ContainerIdentification)o;
        return Objects.equals((Object)this.containerIdentificationType, (Object)containerIdentification.containerIdentificationType) && Objects.equals(this.containerIdentificationNumber, containerIdentification.containerIdentificationNumber);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.containerIdentificationType, this.containerIdentificationNumber});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ContainerIdentification {\n");
        sb.append("    containerIdentificationType: ").append(this.toIndentedString((Object)this.containerIdentificationType)).append("\n");
        sb.append("    containerIdentificationNumber: ").append(this.toIndentedString(this.containerIdentificationNumber)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ContainerIdentificationTypeEnum {
        SSCC("SSCC"),
        AMZNCC("AMZNCC"),
        GTIN("GTIN"),
        BPS("BPS"),
        CID("CID");

        private String value;

        private ContainerIdentificationTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ContainerIdentificationTypeEnum fromValue(String input) {
            for (ContainerIdentificationTypeEnum b : ContainerIdentificationTypeEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ContainerIdentificationTypeEnum> {
            public void write(JsonWriter jsonWriter, ContainerIdentificationTypeEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public ContainerIdentificationTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ContainerIdentificationTypeEnum.fromValue(value);
            }
        }
    }
}

