/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.vendor.orders.v1;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.spapi.models.vendor.orders.v1.Order;
import software.amazon.spapi.models.vendor.orders.v1.Pagination;

@Schema(description="A list of orders returned as response.")
public class OrderList {
    @SerializedName(value="pagination")
    private Pagination pagination = null;
    @SerializedName(value="orders")
    private List<Order> orders = null;

    public OrderList pagination(Pagination pagination) {
        this.pagination = pagination;
        return this;
    }

    @Schema(description="")
    public Pagination getPagination() {
        return this.pagination;
    }

    public void setPagination(Pagination pagination) {
        this.pagination = pagination;
    }

    public OrderList orders(List<Order> orders) {
        this.orders = orders;
        return this;
    }

    public OrderList addOrdersItem(Order ordersItem) {
        if (this.orders == null) {
            this.orders = new ArrayList<Order>();
        }
        this.orders.add(ordersItem);
        return this;
    }

    @Schema(description="Represents an individual order within the OrderList.")
    public List<Order> getOrders() {
        return this.orders;
    }

    public void setOrders(List<Order> orders) {
        this.orders = orders;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderList orderList = (OrderList)o;
        return Objects.equals(this.pagination, orderList.pagination) && Objects.equals(this.orders, orderList.orders);
    }

    public int hashCode() {
        return Objects.hash(this.pagination, this.orders);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrderList {\n");
        sb.append("    pagination: ").append(this.toIndentedString(this.pagination)).append("\n");
        sb.append("    orders: ").append(this.toIndentedString(this.orders)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

